/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.logic.actions;

import icbm.sentry.logic.actions.Action;

public class ActionRepeat
extends Action {
    private int tasksToRepeat;
    private int numReps;
    private int curReps;
    private boolean initialized = false;

    @Override
    public void onTaskStart() {
        this.tasksToRepeat = Math.max(this.getIntArg(0), 0);
        this.numReps = this.getIntArg(1);
        if (this.numReps == 0) {
            this.numReps = -1;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.curReps = 0;
        }
    }

    @Override
    public void onTaskEnd() {
        if (this.curReps < this.numReps || this.numReps == -1) {
            ++this.curReps;
            if (this.tasksToRepeat > 0) {
                this.commandManager.setCurrentTask(this.commandManager.getCurrentTask() - this.tasksToRepeat - 1);
                return;
            }
            this.commandManager.setCurrentTask(-2);
            return;
        }
        this.initialized = false;
    }

    @Override
    public void readFromNBT(bq taskCompound) {
        super.readFromNBT(taskCompound);
        this.initialized = taskCompound.n("repInitialized");
        this.tasksToRepeat = taskCompound.e("repTasks");
        this.curReps = taskCompound.e("repCur");
        this.numReps = taskCompound.e("repGoal");
    }

    @Override
    public void writeToNBT(bq taskCompound) {
        super.writeToNBT(taskCompound);
        taskCompound.a("repInitialized", this.initialized);
        taskCompound.a("repTasks", this.tasksToRepeat);
        taskCompound.a("repCur", this.curReps);
        taskCompound.a("repGoal", this.numReps);
    }
}

