/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry;

import ic2.api.Direction;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.tile.TileEntityElectricityRunnable;

public abstract class TileEntityIC2Runnable
extends TileEntityElectricityRunnable
implements IEnergySink {
    @Override
    public void initiate() {
        super.initiate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
    }

    @Override
    public void w_() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        super.w_();
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        if (this.getConsumingSides() != null) {
            return this.getConsumingSides().contains(direction.toForgeDirection());
        }
        return true;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.ticks > 0L;
    }

    @Override
    public int demandsEnergy() {
        return (int)Math.ceil(this.getRequest().getWatts() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenElectricity = (double)i * UniversalElectricity.IC2_RATIO;
        double rejects = 0.0;
        if (givenElectricity > this.getWattBuffer()) {
            rejects = givenElectricity - this.getRequest().getWatts();
        }
        this.onReceive(new ElectricityPack(givenElectricity / this.getVoltage(new Object[0]), this.getVoltage(new Object[0])));
        return (int)(rejects * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }
}

