/*
 * Decompiled with CFR 0.152.
 */
package icbm.core;

import ic2.api.ICustomElectricItem;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.prefab.ItemElectric;

public abstract class ItIC2ElectricItem
extends ItemElectric
implements ICustomElectricItem {
    public static final float CHARGE_RATE = 0.005f;

    public ItIC2ElectricItem(int id) {
        super(id);
    }

    @Override
    public boolean canProvideEnergy() {
        return this.canProduceElectricity();
    }

    @Override
    public int getChargedItemId() {
        return 0;
    }

    @Override
    public int getEmptyItemId() {
        return 0;
    }

    @Override
    public int getMaxCharge() {
        return (int)(this.getMaxJoules(new Object[0]) * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public int getTransferLimit() {
        return (int)(this.getMaxJoules(new Object[0]) * (double)0.005f * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int charge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double inputElectricity = (double)amount * UniversalElectricity.IC2_RATIO;
        inputElectricity = Math.min(inputElectricity, this.getMaxJoules(new Object[]{itemStack}) - this.getJoules(itemStack));
        if (!ignoreTransferLimit) {
            inputElectricity = Math.min(inputElectricity, this.getMaxJoules(new Object[]{itemStack}) * (double)0.005f);
        }
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) + inputElectricity, itemStack);
        }
        return (int)(inputElectricity * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int discharge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double outputElectricity = (double)amount * UniversalElectricity.IC2_RATIO;
        outputElectricity = Math.min(outputElectricity, this.getJoules(itemStack));
        if (!ignoreTransferLimit) {
            outputElectricity = Math.min(this.getJoules(itemStack), this.getMaxJoules(new Object[]{itemStack}) * (double)0.005f);
        }
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - outputElectricity, itemStack);
        }
        return (int)(outputElectricity * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public boolean canUse(ur itemStack, int amount) {
        return false;
    }

    @Override
    public boolean canShowChargeToolTip(ur itemStack) {
        return false;
    }
}

