/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.prefab.tile.TileEntityElectricityReceiver;

public abstract class TileEntityElectricityStorage
extends TileEntityElectricityReceiver
implements IJouleStorage {
    private double joules = 0.0;
    public double prevJoules = 0.0;

    @Override
    public void g() {
        super.g();
        this.prevJoules = this.joules;
        if (!this.k.I) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetwork.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetwork.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return ElectricityConnections.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack((this.getMaxJoules(new Object[0]) - this.getJoules(new Object[0])) / this.getVoltage(new Object[0]), this.getVoltage(new Object[0]));
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage(new Object[0])) {
            this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 1.5f, true);
            return;
        }
        this.setJoules(this.getJoules(new Object[0]) + electricityPack.getWatts(), new Object[0]);
    }

    public void a(bq par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.joules = par1NBTTagCompound.h("joules");
    }

    public void b(bq par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("joules", this.joules);
    }

    @Override
    public double getJoules(Object ... data) {
        return this.joules;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.joules = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }
}

