/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.electricity;

import universalelectricity.core.electricity.ElectricInfo;

public class ElectricityPack
implements Cloneable {
    public double amperes;
    public double voltage;

    public ElectricityPack(double amperes, double voltage) {
        this.amperes = amperes;
        this.voltage = voltage;
    }

    public ElectricityPack() {
        this(0.0, 0.0);
    }

    public double getWatts() {
        return ElectricInfo.getWatts(this.amperes, this.voltage);
    }

    public double getConductance() {
        return ElectricInfo.getConductance(this.amperes, this.voltage);
    }

    public double getResistance() {
        return ElectricInfo.getResistance(this.amperes, this.voltage);
    }

    public String toString() {
        return "ElectricityPack [Amps:" + this.amperes + " Volts:" + this.voltage + "]";
    }

    public ElectricityPack clone() {
        return new ElectricityPack(this.amperes, this.voltage);
    }

    public boolean isEquals(ElectricityPack electricityPack) {
        return this.amperes == electricityPack.amperes && this.voltage == electricityPack.voltage;
    }
}

