/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.turret;

import com.google.common.io.ByteArrayDataInput;
import icbm.api.explosion.IExplosive;
import icbm.sentry.ICBMSentry;
import icbm.sentry.logic.actions.LookHelper;
import icbm.sentry.turret.EntityFakeMountable;
import icbm.sentry.turret.TileEntityBaseTurret;
import java.util.HashMap;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.TranslationHelper;
import universalelectricity.prefab.implement.IRedstoneReceptor;
import universalelectricity.prefab.multiblock.IMultiBlock;
import universalelectricity.prefab.multiblock.TileEntityMulti;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public class TileEntityRailgun
extends TileEntityBaseTurret
implements IPacketReceiver,
IRedstoneReceptor,
IMultiBlock {
    private qx mountedPlayer = null;
    private EntityFakeMountable entityFake = null;
    private int gunChargingTicks = 0;
    private boolean redstonePowerOn = false;
    private boolean isAntimatter;
    private float explosionSize;
    private int explosionDepth;
    private boolean packetGengXin = true;

    @Override
    public void onUpdate() {
        if (this.mountedPlayer != null) {
            if (this.mountedPlayer.A > 30.0f) {
                this.mountedPlayer.A = 30.0f;
            }
            if (this.mountedPlayer.A < -45.0f) {
                this.mountedPlayer.A = -45.0f;
            }
            this.targetRotationPitch = this.mountedPlayer.A;
            this.targetRotationYaw = this.mountedPlayer.z;
            this.rotationPitch = this.targetRotationPitch * 0.0175f;
            this.rotationYaw = this.targetRotationYaw * 0.0175f;
        } else if (this.entityFake != null) {
            this.entityFake.x();
            this.entityFake = null;
        }
        if (this.getPlatform() != null) {
            if (this.redstonePowerOn && this.canActivateWeapon() && this.gunChargingTicks == 0) {
                this.onWeaponActivated();
            }
            if (this.gunChargingTicks > 0) {
                ++this.gunChargingTicks;
                if (this.gunChargingTicks >= 70) {
                    while (this.explosionDepth > 0) {
                        aoh objectMouseOver = this.rayTrace(2000.0);
                        if (objectMouseOver != null && !ICBMSentry.isProtected(this.k, new Vector3(objectMouseOver), ICBMSentry.FLAG_RAILGUN) && objectMouseOver.a == aoi.a) {
                            if (this.isAntimatter) {
                                int radius = 50;
                                aoe bounds = aoe.a((double)(objectMouseOver.b - radius), (double)(objectMouseOver.c - radius), (double)(objectMouseOver.d - radius), (double)(objectMouseOver.b + radius), (double)(objectMouseOver.c + radius), (double)(objectMouseOver.d + radius));
                                List missilesNearby = this.k.a(lq.class, bounds);
                                for (lq entity : missilesNearby) {
                                    if (!(entity instanceof IExplosive)) continue;
                                    entity.x();
                                }
                            }
                            if (this.k.a(objectMouseOver.b, objectMouseOver.c, objectMouseOver.d) != amq.C.cm) {
                                this.k.e(objectMouseOver.b, objectMouseOver.c, objectMouseOver.d, 0);
                            }
                            this.k.a((lq)this.mountedPlayer, (double)objectMouseOver.b, (double)objectMouseOver.c, (double)objectMouseOver.d, this.explosionSize, true, true);
                        }
                        --this.explosionDepth;
                    }
                    if (!this.k.I) {
                        PacketManager.sendPacketToClients(PacketManager.getPacket("ICBM", this, new Object[]{3}), this.k, new Vector3(this), 50.0);
                    }
                    this.gunChargingTicks = 0;
                }
            }
            if (!this.k.I && this.ticks % 600L == 0L) {
                this.k.i(this.l, this.m, this.n);
            }
        }
    }

    @Override
    public void handlePacketData(ce network, int packetType, di packet, qx player, ByteArrayDataInput dataStream) {
        try {
            int ID = dataStream.readInt();
            if (ID == 1) {
                this.rotationYaw = dataStream.readFloat();
                this.rotationPitch = dataStream.readFloat();
            } else if (ID == 2) {
                this.mount(player);
            } else if (ID == 3 && this.k.I) {
                Vector3 muzzilePosition = this.getMuzzle();
                this.k.a("smoke", muzzilePosition.x, muzzilePosition.y, muzzilePosition.z, 0.0, 0.0, 0.0);
                this.k.a("flame", muzzilePosition.x, muzzilePosition.y, muzzilePosition.z, 0.0, 0.0, 0.0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public ef l() {
        return PacketManager.getPacket("ICBM", this, new Object[]{1, Float.valueOf(this.rotationYaw), Float.valueOf(this.rotationPitch)});
    }

    @Override
    public double getVoltage(Object ... data) {
        return 220.0;
    }

    @Override
    public void onDestroy(any callingBlock) {
        this.k.e(this.l, this.m, this.n, 0);
        this.k.e(this.l, this.m + 1, this.n, 0);
    }

    @Override
    public boolean onActivated(qx entityPlayer) {
        if (this.mountedPlayer != null && entityPlayer == this.mountedPlayer) {
            this.mountedPlayer = null;
            entityPlayer.a(null);
            if (this.entityFake != null) {
                this.entityFake.x();
                this.entityFake = null;
            }
            entityPlayer.d(0.0, 3.0, 0.0);
        } else {
            this.mount(entityPlayer);
        }
        return true;
    }

    public void mount(qx entityPlayer) {
        if (this.mountedPlayer == null) {
            if (!this.k.I) {
                this.entityFake = new EntityFakeMountable(this.k, new Vector3((double)this.l + 0.5, (double)this.m, (double)this.n + 0.5), this, false);
                this.k.d((lq)this.entityFake);
                entityPlayer.a((lq)this.entityFake);
            }
            this.mountedPlayer = entityPlayer;
            entityPlayer.z = 0.0f;
            entityPlayer.A = 0.0f;
        }
    }

    @Override
    public void onCreate(Vector3 position) {
        this.k.e(position.intX(), position.intY() + 1, position.intZ(), ICBMSentry.blockFake.cm);
        ((TileEntityMulti)this.k.q(position.intX(), position.intY() + 1, position.intZ())).setMainBlock(position);
    }

    public aoh rayTrace(double distance) {
        Vector3 muzzlePosition = this.getMuzzle();
        Vector3 lookDistance = LookHelper.getDeltaPositionFromRotation(this.targetRotationYaw, this.targetRotationPitch);
        Vector3 var6 = Vector3.add(muzzlePosition, Vector3.multiply(lookDistance, distance));
        return this.k.a(muzzlePosition.toVec3(), var6.toVec3());
    }

    @Override
    public Vector3 getMuzzle() {
        Vector3 position = new Vector3((double)this.l + 0.5, (double)(this.m + 1), (double)this.n + 0.5);
        return Vector3.add(position, Vector3.multiply(LookHelper.getDeltaPositionFromRotation(this.targetRotationYaw, this.targetRotationPitch - 10.0f), 1.9));
    }

    @Override
    public void a(bq par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.targetRotationYaw = par1NBTTagCompound.g("rotationYaw");
        this.targetRotationPitch = par1NBTTagCompound.g("rotationPitch");
        this.rotationPitch = this.targetRotationPitch * 0.0175f;
        this.rotationYaw = this.targetRotationYaw * 0.0175f;
    }

    @Override
    public void b(bq par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("rotationYaw", this.targetRotationYaw);
        par1NBTTagCompound.a("rotationPitch", this.targetRotationPitch);
        by var2 = new by();
        par1NBTTagCompound.a("Items", (cd)var2);
    }

    @Override
    public void onPowerOn() {
        this.redstonePowerOn = true;
    }

    @Override
    public void onPowerOff() {
        this.redstonePowerOn = false;
    }

    @Override
    public int getCooldown() {
        return 70;
    }

    @Override
    public double getRequest() {
        return 3000000.0;
    }

    @Override
    public void onWeaponActivated() {
        this.gunChargingTicks = 1;
        this.redstonePowerOn = false;
        this.isAntimatter = false;
        this.k.a((double)this.l, (double)this.m, (double)this.n, "icbm.railgun", 5.0f, 1.0f);
        if (this.getPlatform().useAmmunition(ICBMSentry.antimatterBullet)) {
            this.isAntimatter = true;
        } else {
            this.getPlatform().useAmmunition(ICBMSentry.railgunBullet);
        }
        this.getPlatform().wattsReceived = 0.0;
        this.explosionSize = 5.0f;
        this.explosionDepth = 5;
        if (this.isAntimatter) {
            this.explosionSize = 8.0f;
            this.explosionDepth = 10;
        }
    }

    @Override
    public boolean canActivateWeapon() {
        return this.getPlatform() != null && (this.getPlatform().hasAmmunition(ICBMSentry.railgunBullet) || this.getPlatform().hasAmmunition(ICBMSentry.antimatterBullet)) && this.getPlatform().wattsReceived >= this.getRequest();
    }

    @Override
    public float addInformation(HashMap map, qx player) {
        super.addInformation(map, player);
        return 2.0f;
    }

    @Override
    public String getName() {
        return TranslationHelper.getLocal("tile.turret.1.name");
    }

    public aoe getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

