/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.terminal.command;

import icbm.sentry.api.ISpecialAccess;
import icbm.sentry.api.ITerminal;
import icbm.sentry.platform.TileEntityTurretPlatform;
import icbm.sentry.terminal.AccessLevel;
import icbm.sentry.terminal.TerminalCommand;
import java.util.ArrayList;
import java.util.List;

public class CommandAccess
extends TerminalCommand {
    @Override
    public String getCommandPrefix() {
        return "access";
    }

    @Override
    public boolean processCommand(qx player, ITerminal terminal, String[] args) {
        if (args[0].equalsIgnoreCase("access") && args.length > 1 && args[1] != null && terminal instanceof TileEntityTurretPlatform) {
            TileEntityTurretPlatform turret = (TileEntityTurretPlatform)terminal;
            AccessLevel userAccess = terminal.getUserAccess(player.bR);
            if (args[1].equalsIgnoreCase("?")) {
                terminal.addToConsole("Access Level: " + turret.getUserAccess((String)player.bR).displayName);
                return true;
            }
            if (args[1].equalsIgnoreCase("set") && args.length > 3 && userAccess.ordinal() >= AccessLevel.ADMIN.ordinal()) {
                String username = args[2];
                AccessLevel currentAccess = terminal.getUserAccess(username);
                if (username.equalsIgnoreCase("~root")) {
                    terminal.addToConsole("WIP");
                } else if (currentAccess != AccessLevel.NONE) {
                    AccessLevel newAccess = AccessLevel.get(args[3]);
                    if ((currentAccess != AccessLevel.OWNER || turret.getUsersWithAcess(AccessLevel.OWNER).size() > 1) && newAccess != AccessLevel.NONE && terminal.addUserAccess(username, newAccess, true)) {
                        terminal.addToConsole(username + " set to " + newAccess.displayName);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean canPlayerUse(qx var1, ISpecialAccess mm) {
        return mm.getUserAccess(var1.bR).ordinal() >= AccessLevel.BASIC.ordinal();
    }

    @Override
    public boolean showOnHelp(qx player, ISpecialAccess mm) {
        return this.canPlayerUse(player, mm);
    }

    @Override
    public List getCmdUses(qx player, ISpecialAccess mm) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("access set ~root [pass]");
        cmds.add("access set username level");
        cmds.add("access ?");
        return cmds;
    }

    @Override
    public boolean canMachineUse(ISpecialAccess mm) {
        return mm instanceof TileEntityTurretPlatform;
    }
}

