/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.terminal;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.PacketDispatcher;
import icbm.sentry.TileEntityIC2Runnable;
import icbm.sentry.api.ISpecialAccess;
import icbm.sentry.api.ITerminal;
import icbm.sentry.terminal.AccessLevel;
import icbm.sentry.terminal.CommandRegistry;
import icbm.sentry.terminal.UserAccess;
import java.util.ArrayList;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;
import universalelectricity.prefab.network.PacketManager;

public abstract class TileEntityTerminal
extends TileEntityIC2Runnable
implements ISpecialAccess,
IPacketReceiver,
ITerminal {
    private final List terminalOutput = new ArrayList();
    private final List users = new ArrayList();
    public int playersUsing = 0;
    public static final int SCROLL_SIZE = 15;
    private int scroll = 0;

    @Override
    public void initiate() {
        super.initiate();
    }

    @Override
    public void g() {
        super.g();
        if (!this.k.I && this.playersUsing > 0 && this.ticks % 5L == 0L) {
            PacketManager.sendPacketToClients(this.l(), this.k, new Vector3(this), 12.0);
        }
    }

    public ef l() {
        bq nbt = new bq();
        this.b(nbt);
        return PacketManager.getPacket("ICBM", this, new Object[]{PacketType.DESCRIPTION_DATA.ordinal(), nbt});
    }

    public void sendTerminalOutputToClients() {
        ArrayList<Integer> data = new ArrayList<Integer>();
        data.add(PacketType.TERMINAL_OUTPUT.ordinal());
        data.add(this.getTerminalOuput().size());
        data.addAll(this.getTerminalOuput());
        ef packet = PacketManager.getPacket("ICBM", this, data.toArray());
        PacketManager.sendPacketToClients(packet, this.k, new Vector3(this), 10.0);
    }

    public void sendCommandToServer(qx entityPlayer, String cmdInput) {
        if (this.k.I) {
            ef packet = PacketManager.getPacket("ICBM", this, new Object[]{PacketType.GUI_COMMAND.ordinal(), entityPlayer.bR, cmdInput});
            PacketDispatcher.sendPacketToServer((ef)packet);
        }
    }

    @Override
    public void handlePacketData(ce network, int packetID, di packet, qx player, ByteArrayDataInput dataStream) {
        try {
            PacketType packetType = PacketType.values()[dataStream.readInt()];
            switch (packetType) {
                case DESCRIPTION_DATA: {
                    if (!this.k.I) break;
                    short size = dataStream.readShort();
                    if (size > 0) {
                        byte[] byteCode = new byte[size];
                        dataStream.readFully(byteCode);
                        this.a(ca.a((byte[])byteCode));
                    }
                    break;
                }
                case GUI_COMMAND: {
                    if (this.k.I) break;
                    CommandRegistry.onCommand(this.k.a(dataStream.readUTF()), this, dataStream.readUTF());
                    this.sendTerminalOutputToClients();
                    break;
                }
                case GUI_EVENT: {
                    if (this.k.I) break;
                    if (dataStream.readBoolean()) {
                        ++this.playersUsing;
                        this.sendTerminalOutputToClients();
                        break;
                    }
                    --this.playersUsing;
                    break;
                }
                case TERMINAL_OUTPUT: {
                    if (!this.k.I) break;
                    int size = dataStream.readInt();
                    ArrayList oldTerminalOutput = new ArrayList(this.terminalOutput);
                    this.terminalOutput.clear();
                    for (int i = 0; i < size; ++i) {
                        this.terminalOutput.add(dataStream.readUTF());
                    }
                    if (!this.terminalOutput.equals(oldTerminalOutput) && this.terminalOutput.size() != oldTerminalOutput.size()) {
                        this.setScroll(this.getTerminalOuput().size() - 15);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"ICBM: Failed to receive packet for terminal.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public AccessLevel getUserAccess(String username) {
        for (int i = 0; i < this.users.size(); ++i) {
            if (!((UserAccess)this.users.get((int)i)).username.equalsIgnoreCase(username)) continue;
            return ((UserAccess)this.users.get((int)i)).level;
        }
        return AccessLevel.NONE;
    }

    @Override
    public List getUsers() {
        return this.users;
    }

    @Override
    public List getUsersWithAcess(AccessLevel level) {
        ArrayList<UserAccess> players = new ArrayList<UserAccess>();
        for (int i = 0; i < this.users.size(); ++i) {
            UserAccess ref = (UserAccess)this.users.get(i);
            if (ref.level != level) continue;
            players.add(ref);
        }
        return players;
    }

    @Override
    public boolean addUserAccess(String player, AccessLevel lvl, boolean save) {
        this.removeUserAccess(player);
        return this.users.add(new UserAccess(player, lvl, save));
    }

    @Override
    public boolean removeUserAccess(String player) {
        ArrayList<UserAccess> removeList = new ArrayList<UserAccess>();
        for (int i = 0; i < this.users.size(); ++i) {
            UserAccess ref = (UserAccess)this.users.get(i);
            if (!ref.username.equalsIgnoreCase(player)) continue;
            removeList.add(ref);
        }
        if (removeList != null && removeList.size() > 0) {
            return this.users.removeAll(removeList);
        }
        return false;
    }

    @Override
    public List getTerminalOuput() {
        return this.terminalOutput;
    }

    @Override
    public boolean addToConsole(String msg) {
        if (!this.k.I) {
            boolean usedLines = false;
            msg.trim();
            if (msg.length() > 23) {
                msg = msg.substring(0, 22);
            }
            this.getTerminalOuput().add(msg);
            this.sendTerminalOutputToClients();
            return true;
        }
        return false;
    }

    @Override
    public void scroll(int amount) {
        this.setScroll(this.scroll + amount);
    }

    @Override
    public void setScroll(int length) {
        this.scroll = Math.max(Math.min(length, this.getTerminalOuput().size()), 0);
    }

    @Override
    public int getScroll() {
        return this.scroll;
    }

    public void a(bq nbt) {
        super.a(nbt);
        this.wattsReceived = nbt.h("wattsReceived");
        this.users.clear();
        by userList = nbt.m("Users");
        for (int i = 0; i < userList.c(); ++i) {
            bq var4 = (bq)userList.b(i);
            this.users.add(UserAccess.loadFromNBT(var4));
        }
    }

    public void b(bq nbt) {
        super.b(nbt);
        nbt.a("wattsReceived", this.wattsReceived);
        by usersTag = new by();
        for (int player = 0; player < this.users.size(); ++player) {
            UserAccess access = (UserAccess)this.users.get(player);
            if (access == null || !access.shouldSave) continue;
            bq accessData = new bq();
            access.writeToNBT(accessData);
            usersTag.a((cd)accessData);
        }
        nbt.a("Users", (cd)usersTag);
    }

    public static enum PacketType {
        GUI_EVENT,
        GUI_COMMAND,
        TERMINAL_OUTPUT,
        DESCRIPTION_DATA;

    }
}

