/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.logic.actions;

import icbm.sentry.logic.actions.Action;

public class ActionRotateTo
extends Action {
    float targetRotationYaw = 0.0f;
    float targetRotationPitch = 0.0f;

    @Override
    public void onTaskStart() {
        super.onTaskStart();
        this.targetRotationYaw = this.getArg(0) != null ? this.getFloatArg(0).floatValue() : 0.0f;
        this.targetRotationPitch = this.getArg(1) != null ? this.getFloatArg(1).floatValue() : 0.0f;
        while (this.targetRotationYaw < 0.0f) {
            this.targetRotationYaw += 360.0f;
        }
        while (this.targetRotationYaw > 360.0f) {
            this.targetRotationYaw -= 360.0f;
        }
        while (this.targetRotationPitch < -30.0f) {
            this.targetRotationPitch += 30.0f;
        }
        while (this.targetRotationPitch > 30.0f) {
            this.targetRotationPitch -= 30.0f;
        }
    }

    @Override
    protected boolean onUpdateTask() {
        super.onUpdateTask();
        this.tileEntity.targetRotationYaw = this.targetRotationYaw;
        this.tileEntity.targetRotationPitch = this.targetRotationPitch;
        if (Math.abs(this.tileEntity.rotationPitch - this.tileEntity.targetRotationPitch) > 0.001f) {
            return true;
        }
        return Math.abs(this.tileEntity.rotationYaw - this.tileEntity.targetRotationYaw) > 0.001f;
    }

    public String toString() {
        return "ROTATETO " + Float.toString(this.targetRotationYaw) + " " + Float.toString(this.targetRotationPitch);
    }

    @Override
    public void readFromNBT(bq taskCompound) {
        super.readFromNBT(taskCompound);
        this.targetRotationPitch = taskCompound.g("rotPitch");
        this.targetRotationYaw = taskCompound.g("rotYaw");
    }

    @Override
    public void writeToNBT(bq taskCompound) {
        super.writeToNBT(taskCompound);
        taskCompound.a("rotPitch", this.targetRotationPitch);
        taskCompound.a("rotYaw", this.targetRotationYaw);
    }
}

