/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.logic.actions;

import cpw.mods.fml.common.FMLLog;
import icbm.sentry.logic.actions.Action;
import icbm.sentry.logic.actions.ActionRepeat;
import icbm.sentry.turret.TileEntityBaseTurret;
import java.util.ArrayList;
import java.util.List;

public class ActionManager {
    private final List tasks = new ArrayList();
    private int ticks = 0;
    private int currentTask = 0;
    private int lastTask = -1;

    public void onUpdate() {
        try {
            if (this.tasks.size() > 0) {
                if (this.currentTask < this.tasks.size()) {
                    if (this.currentTask < 0) {
                        this.currentTask = 0;
                        this.lastTask = -1;
                    }
                    Action task = (Action)this.tasks.get(this.currentTask);
                    if (this.currentTask != this.lastTask) {
                        this.lastTask = this.currentTask;
                        task.onTaskStart();
                    }
                    if (!task.onUpdateTask()) {
                        int tempCurrentTask = this.currentTask++;
                        task.onTaskEnd();
                        if (!(task instanceof ActionRepeat)) {
                            this.tasks.set(tempCurrentTask, this.getNewCommand(task.tileEntity, task.getClass(), task.getArgs()));
                        }
                    }
                } else {
                    this.clear();
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to execute task in Assembly Line.", (Object[])new Object[0]);
            e.printStackTrace();
        }
        ++this.ticks;
    }

    public Action getNewCommand(TileEntityBaseTurret tileEntity, Class commandClass, String[] parameters) {
        try {
            Action newCommand = (Action)commandClass.newInstance();
            newCommand.world = tileEntity.k;
            newCommand.tileEntity = tileEntity;
            newCommand.commandManager = this;
            newCommand.setParameters(parameters);
            return newCommand;
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to add command", (Object[])new Object[0]);
            e.printStackTrace();
            return null;
        }
    }

    public void addCommand(TileEntityBaseTurret tileEntity, Class commandClass, String[] parameters) {
        Action newCommand = this.getNewCommand(tileEntity, commandClass, parameters);
        if (newCommand != null) {
            this.tasks.add(newCommand);
        }
    }

    public void addCommand(TileEntityBaseTurret tileEntity, Class task) {
        this.addCommand(tileEntity, task, new String[0]);
    }

    public boolean hasTasks() {
        return this.tasks.size() > 0;
    }

    public List getCommands() {
        return this.tasks;
    }

    public void clear() {
        this.tasks.clear();
        this.currentTask = 0;
        this.lastTask = -1;
        this.ticks = 0;
    }

    public void setCurrentTask(int i) {
        this.currentTask = Math.min(i, this.tasks.size());
    }

    public int getCurrentTask() {
        return this.currentTask;
    }
}

