/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;

public class PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static void writeNBTTagCompound(bq tag, DataOutputStream stream) throws IOException {
        if (tag == null) {
            stream.writeShort(-1);
        } else {
            byte[] var2 = ca.a((bq)tag);
            stream.writeShort((short)var2.length);
            stream.write(var2);
        }
    }

    public static ef getPacketWithID(String channelName, int id, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(id);
            data = PacketManager.encodeDataStream(data, sendData);
            di packet = new di();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static ef getPacket(String channelName, Object ... sendData) {
        return PacketManager.getPacketWithID(channelName, PacketType.UNSPECIFIED.ordinal(), sendData);
    }

    public static ef getPacket(String channelName, any sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(PacketType.TILEENTITY.ordinal());
            data.writeInt(sender.l);
            data.writeInt(sender.m);
            data.writeInt(sender.n);
            data = PacketManager.encodeDataStream(data, sendData);
            di packet = new di();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToClients(ef packet, yc worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.u.h, (ef)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(ef packet, yc worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((ef)packet, (int)worldObj.u.h);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(ef packet) {
        try {
            PacketDispatcher.sendPacketToAllPlayers((ef)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (!(dataValue instanceof bq)) continue;
                PacketManager.writeNBTTagCompound((bq)dataValue, data);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(ce network, di packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            int packetTypeID = data.readInt();
            PacketType packetType = PacketType.get(packetTypeID);
            if (packetType == PacketType.TILEENTITY) {
                any tileEntity;
                int x = data.readInt();
                int y2 = data.readInt();
                int z2 = data.readInt();
                yc world = ((qx)player).p;
                if (world != null && (tileEntity = world.q(x, y2, z2)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (qx)player, data);
                }
            } else {
                this.handlePacketData(network, packetTypeID, packet, (qx)player, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(ce network, int packetType, di packet, qx player, ByteArrayDataInput dataStream) {
    }

    public static enum PacketType {
        UNSPECIFIED,
        TILEENTITY;


        public static PacketType get(int id) {
            if (id >= 0 && id < PacketType.values().length) {
                return PacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

