/*
 * Decompiled with CFR 0.152.
 */
package icbm.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import universalelectricity.core.vector.Vector2;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.vector.Region2;

public class RadarRegistry {
    private static List detectableTileEntities = new ArrayList();
    private static List detectableEntities = new ArrayList();

    public static void register(any tileEntity) {
        if (!detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.add(tileEntity);
        }
    }

    public static void unregister(any tileEntity) {
        if (detectableTileEntities.contains(tileEntity)) {
            detectableTileEntities.remove(tileEntity);
        }
    }

    public static void register(lq entity) {
        if (!detectableEntities.contains(entity)) {
            detectableEntities.add(entity);
        }
    }

    public static void unregister(lq entity) {
        if (detectableEntities.contains(entity)) {
            detectableEntities.remove(entity);
        }
    }

    public static List getTileEntitiesInArea(Vector2 minVector, Vector2 maxVector) {
        RadarRegistry.cleanUpArray();
        ArrayList<any> returnArray = new ArrayList<any>();
        for (any tileEntity : detectableTileEntities) {
            if (!new Region2(minVector, maxVector).isIn(new Vector3(tileEntity).toVector2())) continue;
            returnArray.add(tileEntity);
        }
        return returnArray;
    }

    public static List getEntitiesWithinRadius(Vector2 vector, int radius) {
        RadarRegistry.cleanUpArray();
        ArrayList<lq> returnArray = new ArrayList<lq>();
        for (lq entity : detectableEntities) {
            Vector3 vector3 = new Vector3(entity);
            if (!(Vector2.distance(vector, vector3.toVector2()) <= (double)radius)) continue;
            returnArray.add(entity);
        }
        return returnArray;
    }

    public static List getTileEntities() {
        RadarRegistry.cleanUpArray();
        return detectableTileEntities;
    }

    public static List getEntities() {
        RadarRegistry.cleanUpArray();
        return detectableEntities;
    }

    public static void cleanUpArray() {
        try {
            Iterator it = detectableTileEntities.iterator();
            while (it.hasNext()) {
                any tileEntity = (any)it.next();
                if (tileEntity == null) {
                    it.remove();
                    continue;
                }
                if (tileEntity.r()) {
                    it.remove();
                    continue;
                }
                if (tileEntity.k.q(tileEntity.l, tileEntity.m, tileEntity.n) == tileEntity) continue;
                it.remove();
            }
            Iterator it2 = detectableEntities.iterator();
            while (it2.hasNext()) {
                lq entity = (lq)it2.next();
                if (entity == null) {
                    it2.remove();
                    continue;
                }
                if (!entity.L) continue;
                it2.remove();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to clean up radar list properly.");
            e.printStackTrace();
        }
    }
}

