/*
 * Decompiled with CFR 0.152.
 */
package easymodinstaller;

import easymodinstaller.EasyModInstallerAboutBox;
import easymodinstaller.EasyModInstallerApp;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SortedSet;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class EasyModInstallerView
extends FrameView {
    public int progress = 0;
    private File[] files;
    private File zipFil;
    private String splitter = this.ID("into_jar");
    private boolean modloader = false;
    private boolean meta = false;
    private boolean audiomod = false;
    private String loc = "";
    public static final int LIST = 0;
    public static final int EXTRACT = 1;
    protected int mode = 0;
    protected ZipFile zippy;
    protected byte[] b;
    protected SortedSet dirsMade;
    public int filecount = 0;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JOptionPane jOptionPane1;
    private JProgressBar jProgressBar1;
    private JPanel mainPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    public String makeUTF8(String toConvert) {
        try {
            return new String(toConvert.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getJarFolder() {
        String name = this.getClass().getName().replace('.', '/');
        String s = this.getClass().getResource("/" + name + ".class").toString();
        s = s.replace('/', File.separatorChar);
        s = s.substring(0, s.indexOf(".jar") + 4);
        s = s.substring(s.lastIndexOf(58) - 1);
        return this.makeUTF8(s.substring(0, s.lastIndexOf(File.separatorChar) + 1));
    }

    private String ID(String f) {
        try {
            Properties p = new Properties();
            String working_dir = System.getProperty("user.dir");
            String loca = "";
            loca = loca + "install.emi";
            p.load(new FileInputStream(loca));
            String x = p.getProperty(f);
            return x;
        }
        catch (Exception e) {
            System.out.println(e);
            return "";
        }
    }

    public EasyModInstallerView(SingleFrameApplication app) {
        super(app);
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.initComponents();
        String title = this.ID("title");
        title = title + " - Easy Mod Installer V 1.3 Beta by Burnner";
        super.getFrame().setTitle(title);
        super.getFrame().setResizable(false);
        this.jProgressBar1.setVisible(false);
        this.jLabel3.setVisible(false);
        JFrame jFrame = super.getFrame();
        super.getFrame();
        super.getFrame();
        jFrame.setSize(1, 2 - 185);
        this.jLabel3.setText("");
        this.jLabel2.setText(this.ID("by"));
        try {
            ImageIcon icon = new ImageIcon(this.ID("image"));
            this.jLabel1.setIcon(icon);
            this.jLabel1.setText("");
            int width = super.getFrame().getWidth() / 2 - icon.getIconWidth();
            this.jLabel1.setSize(icon.getIconHeight(), icon.getIconWidth());
        }
        catch (Exception e) {
            // empty catch block
        }
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EasyModInstallerView.this.busyIconIndex = (EasyModInstallerView.this.busyIconIndex + 1) % EasyModInstallerView.this.busyIcons.length;
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!EasyModInstallerView.this.busyIconTimer.isRunning()) {
                        EasyModInstallerView.this.busyIconIndex = 0;
                        EasyModInstallerView.this.busyIconTimer.start();
                    }
                } else if ("done".equals(propertyName)) {
                    EasyModInstallerView.this.busyIconTimer.stop();
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    EasyModInstallerView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int n = (Integer)evt.getNewValue();
                }
            }
        });
    }

    protected void updatePBar(final int val) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EasyModInstallerView.this.jProgressBar1.setValue(val);
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = EasyModInstallerApp.getApplication().getMainFrame();
            this.aboutBox = new EasyModInstallerAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        EasyModInstallerApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jButton1 = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jFileChooser1 = new JFileChooser();
        this.jOptionPane1 = new JOptionPane();
        this.mainPanel.setName("mainPanel");
        this.jProgressBar1.setName("jProgressBar1");
        ApplicationActionMap actionMap = Application.getInstance(EasyModInstallerApp.class).getContext().getActionMap(EasyModInstallerView.class, this);
        this.jButton1.setAction(actionMap.get("install"));
        ResourceMap resourceMap = Application.getInstance(EasyModInstallerApp.class).getContext().getResourceMap(EasyModInstallerView.class);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, 103, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, 103, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, 103, Short.MAX_VALUE).addComponent(this.jProgressBar1, GroupLayout.Alignment.TRAILING, -1, 103, Short.MAX_VALUE).addComponent(this.jButton1, -1, 103, Short.MAX_VALUE)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, 164, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3).addContainerGap(-1, Short.MAX_VALUE)));
        this.jFileChooser1.setDialogTitle(resourceMap.getString("jFileChooser1.dialogTitle", new Object[0]));
        this.jFileChooser1.setName("jFileChooser1");
        this.jOptionPane1.setName("jOptionPane1");
        this.setComponent(this.mainPanel);
    }

    @Action
    public void install() {
        File jar = new File((this.getAppDir("minecraft").getAbsolutePath() + "/bin/minecraft.jar").replace("\\", "/"));
        int height = super.getFrame().getHeight() + 90;
        int width = super.getFrame().getWidth();
        super.getFrame().setSize(width, height);
        this.jButton1.setEnabled(false);
        this.jProgressBar1.setVisible(true);
        this.jLabel3.setVisible(true);
        this.installmod(jar);
    }

    public boolean installmod(File jar) {
        File f = new File(this.splitter);
        File[] fileArray = f.listFiles();
        this.zipFil = jar;
        this.files = fileArray;
        this.jLabel3.setText("Adding files to the jar...");
        Thread in = new Thread(){
            private File logfile = new File("log.txt");
            private FileWriter log;
            private int count = 0;
            private BufferedInputStream in = null;
            private BufferedOutputStream out = null;

            private void addDir(File dirObj, JarOutputStream out) throws IOException {
                File[] files = dirObj.listFiles();
                byte[] tmpBuf = new byte[1024];
                for (int i = 0; i < files.length; ++i) {
                    int len;
                    if (files[i].isDirectory()) {
                        this.addDir(files[i], out);
                        continue;
                    }
                    FileInputStream in = new FileInputStream(files[i].getAbsolutePath());
                    ++this.count;
                    if (files[i].getName() != "") {
                        String temp = files[i].getPath();
                        String[] name = temp.split("emitemp");
                        temp = name[1].substring(1).replace('\\', '/');
                        EasyModInstallerView.this.jLabel3.setText(" Adding: " + temp);
                        this.log.write(" Adding: " + temp);
                        this.log.write("\r\n");
                        if (temp.endsWith("aux_class")) {
                            temp = name[1].substring(1).replace("aux_class", "aux.class");
                        }
                        out.putNextEntry(new ZipEntry(temp));
                    }
                    while ((len = in.read(tmpBuf)) > 0) {
                        out.write(tmpBuf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
            }

            private File buildDirectoryHierarchyFor(String entryName, File destDir) {
                int lastIndex = entryName.lastIndexOf(47);
                String entryFileName = entryName.substring(lastIndex + 1);
                String internalPathToEntry = entryName.substring(0, lastIndex + 1);
                return new File(destDir, internalPathToEntry);
            }

            public void copyDir(File quelle, File ziel) throws FileNotFoundException, IOException {
                File[] files = quelle.listFiles();
                ziel.mkdirs();
                for (File file : files) {
                    ++EasyModInstallerView.this.filecount;
                    if (file.isDirectory()) {
                        this.copyDir(file, new File(ziel.getAbsolutePath() + System.getProperty("file.separator") + file.getName()));
                        continue;
                    }
                    this.copyFile(file, new File(ziel.getAbsolutePath() + System.getProperty("file.separator") + file.getName()));
                }
            }

            public void copyFile(File file, File ziel) throws FileNotFoundException, IOException {
                this.in = new BufferedInputStream(new FileInputStream(file));
                this.out = new BufferedOutputStream(new FileOutputStream(ziel, false));
                int bytes = 0;
                while ((bytes = this.in.read()) != -1) {
                    this.out.write(bytes);
                }
                this.in.close();
                this.out.close();
            }

            public boolean deleteDirectory(File path) {
                if (path.exists()) {
                    File[] files = path.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            this.deleteDirectory(files[i]);
                            continue;
                        }
                        files[i].delete();
                    }
                }
                return path.delete();
            }

            public void downloadFile(String url_str, OutputStream os) throws IllegalStateException, MalformedURLException, ProtocolException, IOException {
                URL url = new URL(url_str.replace(" ", "%20"));
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                EasyModInstallerView.this.jLabel3.setText("Connect to " + url.toString());
                conn.connect();
                EasyModInstallerView.this.jLabel3.setText("Downloading....");
                int responseCode = conn.getResponseCode();
                boolean hit = false;
                if (responseCode == 200) {
                    int n;
                    byte[] tmp_buffer = new byte[4096];
                    InputStream is = conn.getInputStream();
                    while ((n = is.read(tmp_buffer)) > 0) {
                        os.write(tmp_buffer, 0, n);
                        os.flush();
                    }
                } else {
                    throw new IllegalStateException("HTTP response: " + responseCode);
                }
            }

            public String ModLoader() {
                return EasyModInstallerView.this.ID("ModLoader");
            }

            public String ModAudio() {
                return EasyModInstallerView.this.ID("AudioMod");
            }

            public void extractArchive(File archive, File destDir) throws Exception {
                if (!destDir.exists()) {
                    destDir.mkdir();
                }
                ZipFile zipFile = new ZipFile(archive);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                byte[] buffer = new byte[16384];
                while (entries.hasMoreElements()) {
                    int len;
                    ZipEntry entry = entries.nextElement();
                    String entryFileName = entry.getName();
                    File dir = this.buildDirectoryHierarchyFor(entryFileName, destDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    if (entry.isDirectory()) continue;
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(destDir, entryFileName)));
                    BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                    while ((len = bis.read(buffer)) > 0) {
                        bos.write(buffer, 0, len);
                    }
                    bos.flush();
                    bos.close();
                    bis.close();
                }
                zipFile.close();
            }

            public void run() {
                String working_dir = System.getProperty("user.dir");
                try {
                    File loader;
                    FileOutputStream fos;
                    String[] pfade;
                    String url;
                    this.log = new FileWriter(this.logfile);
                    this.log.write(EasyModInstallerView.this.zipFil.getAbsolutePath() + "\r\n");
                    boolean counter = false;
                    this.updatePBar(5);
                    String extract = EasyModInstallerView.this.zipFil.getAbsolutePath().toString().replace("\\", "/");
                    extract = extract + "emitemp";
                    EasyModInstallerView.this.loc = extract;
                    EasyModInstallerView.this.loc = EasyModInstallerView.this.loc + "/";
                    File archive = new File(EasyModInstallerView.this.zipFil.getAbsolutePath());
                    File destDir = new File(extract);
                    if (!destDir.exists()) {
                        destDir.mkdir();
                    }
                    ZipFile zipFile = new ZipFile(archive);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    zipFile.close();
                    zipFile = new ZipFile(archive);
                    entries = zipFile.entries();
                    byte[] buffer = new byte[16384];
                    while (entries.hasMoreElements()) {
                        int len;
                        ZipEntry entry = entries.nextElement();
                        String entryFileName = entry.getName();
                        EasyModInstallerView.this.jLabel3.setText("Extracting " + entry.getName());
                        if (entry.getName().endsWith("MANIFEST.MF")) {
                            EasyModInstallerView.this.meta = true;
                        }
                        if (entry.getName().endsWith("ModLoader.class")) {
                            EasyModInstallerView.this.modloader = true;
                        }
                        if (entry.getName().endsWith("CodecIBXM.class")) {
                            EasyModInstallerView.this.audiomod = true;
                        }
                        if (entry.getName().endsWith("aux.class")) {
                            entryFileName = "aux_class";
                            this.log.write("aux.class replaced");
                            this.log.write("\r\n");
                        }
                        File dir = this.buildDirectoryHierarchyFor(entryFileName, destDir);
                        if (!dir.exists()) {
                            dir.mkdirs();
                        }
                        if (entry.isDirectory()) continue;
                        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(destDir, entryFileName)));
                        BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(entry));
                        while ((len = bis.read(buffer)) > 0) {
                            bos.write(buffer, 0, len);
                        }
                        bos.flush();
                        bos.close();
                        bis.close();
                    }
                    zipFile.close();
                    this.updatePBar(20);
                    if (EasyModInstallerView.this.meta) {
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        if (0 == JOptionPane.showConfirmDialog(null, "Do you want to delete the meta-inf folder? (Required for most mods!)", "Meta-Inf Folder", 0)) {
                            EasyModInstallerView.this.jLabel3.setText("Delete Meta-Inf...");
                            String meta = extract;
                            meta = meta + "/META-INF";
                            File arch = new File(meta);
                            this.deleteDirectory(arch);
                            this.log.write("META-INF removed");
                            this.log.write("\r\n");
                        } else {
                            this.log.write("META-INF not removed");
                            this.log.write("\r\n");
                        }
                    }
                    if (!EasyModInstallerView.this.modloader) {
                        this.log.write("ModLoader not found");
                        this.log.write("\r\n");
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        if (0 == JOptionPane.showConfirmDialog(null, "Do you want to download and install ModLoader? (Required for most mods!)", "ModLoader", 0)) {
                            EasyModInstallerView.this.jLabel3.setText("Get ModLoader url...");
                            url = this.ModLoader();
                            if (url != "") {
                                pfade = EasyModInstallerView.this.zipFil.getAbsolutePath().split(EasyModInstallerView.this.zipFil.getName());
                                fos = new FileOutputStream(pfade[0].replace('\\', '/') + "modloader.zip");
                                this.downloadFile(url, fos);
                                fos.close();
                                loader = new File(pfade[0].replace('\\', '/') + "modloader.zip");
                                EasyModInstallerView.this.jLabel3.setText("extracting ModLoader.zip...");
                                this.extractArchive(loader, destDir);
                                this.log.write("ModLoader installed");
                                this.log.write("\r\n");
                            } else {
                                this.log.write("ModLoader Url failed");
                                this.log.write("\r\n");
                            }
                        }
                    }
                    if (!EasyModInstallerView.this.audiomod) {
                        this.log.write("Audiomod not found");
                        this.log.write("\r\n");
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        EasyModInstallerView.this.jOptionPane1;
                        if (0 == JOptionPane.showConfirmDialog(null, "Do you want to download and install AudioMod?", "AudioMod", 0)) {
                            EasyModInstallerView.this.jLabel3.setText("Get AudioMod url...");
                            url = this.ModAudio();
                            if (url != "") {
                                pfade = EasyModInstallerView.this.zipFil.getAbsolutePath().split(EasyModInstallerView.this.zipFil.getName());
                                fos = new FileOutputStream(pfade[0].replace('\\', '/') + "audiomod.zip");
                                this.downloadFile(url, fos);
                                fos.close();
                                loader = new File(pfade[0].replace('\\', '/') + "audiomod.zip");
                                EasyModInstallerView.this.jLabel3.setText("extracting audiomod.zip...");
                                this.extractArchive(loader, destDir);
                                this.log.write("audiomod installed");
                                this.log.write("\r\n");
                            } else {
                                this.log.write("audiomod Url failed");
                                this.log.write("\r\n");
                            }
                        }
                    }
                    EasyModInstallerView.this.jLabel3.setText("Backup Minecraft.jar...");
                    this.updatePBar(20);
                    archive = new File(EasyModInstallerView.this.zipFil.getAbsolutePath());
                    String[] extract2 = EasyModInstallerView.this.zipFil.getAbsolutePath().split(EasyModInstallerView.this.zipFil.getName());
                    extract2[0] = extract2[0] + "emibackup.jar";
                    System.out.println(extract2[0]);
                    File Backup = new File(extract2[0].toString());
                    if (Backup.exists()) {
                        Backup.delete();
                    }
                    archive.renameTo(Backup);
                    EasyModInstallerView.this.jLabel3.setText("Move Mod-files...");
                    File quelle = new File(working_dir + "/" + EasyModInstallerView.this.ID("into_jar"));
                    if (quelle.exists()) {
                        this.copyDir(quelle, new File(extract));
                    }
                    this.updatePBar(40);
                    String extract3 = EasyModInstallerView.this.zipFil.getAbsolutePath().replace("\\", "/");
                    this.updatePBar(70);
                    EasyModInstallerView.this.jLabel3.setText("Write modified minecraft.jar...");
                    String sourceDir = extract.replace('\\', '/');
                    String zip = extract3.replace('\\', '/');
                    File dirObj = new File(sourceDir);
                    JarOutputStream out = new JarOutputStream(new FileOutputStream(zip));
                    EasyModInstallerView.this.jLabel3.setText("Creating : " + zip);
                    this.addDir(dirObj, out);
                    out.close();
                    EasyModInstallerView.this.jLabel3.setText("Move files into .minecraft..." + zip);
                    this.updatePBar(90);
                    String[] minefolder = extract.toString().split("bin");
                    File quelle2 = new File(working_dir + "/" + EasyModInstallerView.this.ID("into_minecraft"));
                    if (quelle2.exists() && !EasyModInstallerView.this.ID("into_minecraft").isEmpty()) {
                        this.copyDir(quelle2, new File(minefolder[0]));
                    }
                    EasyModInstallerView.this.jLabel3.setText("Cleaning up...");
                    File arch = new File(extract);
                    this.deleteDirectory(arch);
                    this.updatePBar(100);
                    EasyModInstallerView.this.jProgressBar1.setValue(100);
                    if (!EasyModInstallerView.this.modloader) {
                        this.log.write("ModLoader not found");
                        this.log.write("\r\n");
                    }
                    EasyModInstallerView.this.jLabel3.setText("Done!");
                    this.log.close();
                }
                catch (Exception e) {
                    EasyModInstallerView.this.jLabel3.setText("Failure");
                    EasyModInstallerView.this.jOptionPane1;
                    EasyModInstallerView.this.jOptionPane1;
                    JOptionPane.showMessageDialog(null, e, "Error", 0);
                    EasyModInstallerView.this.jProgressBar1.setValue(0);
                    try {
                        this.log.write(e.toString());
                        this.log.write("\r\n");
                        this.log.close();
                        EasyModInstallerView.this.modloader = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            protected void updatePBar(final int val) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EasyModInstallerView.this.jProgressBar1.setValue(val);
                    }
                });
            }
        };
        in.start();
        return true;
    }

    public File getAppDir(String s) {
        File file;
        String s1 = System.getProperty("user.home", ".");
        switch (this.getOs()) {
            case 1: 
            case 2: {
                file = new File(s1, '.' + s + '/');
                break;
            }
            case 3: {
                String s2 = System.getenv("APPDATA");
                if (s2 != null) {
                    file = new File(s2, "." + s + '/');
                    break;
                }
                file = new File(s1, '.' + s + '/');
                break;
            }
            case 4: {
                file = new File(s1, "Library/Application Support/" + s);
                break;
            }
            default: {
                file = new File(s1, s + '/');
            }
        }
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file);
        }
        return file;
    }

    private int getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return 3;
        }
        if (s.contains("mac")) {
            return 4;
        }
        if (s.contains("solaris")) {
            return 2;
        }
        if (s.contains("sunos")) {
            return 2;
        }
        if (s.contains("linux")) {
            return 1;
        }
        if (s.contains("unix")) {
            return 1;
        }
        return 6;
    }

    public class FileNameFilter
    extends FileFilter {
        public boolean accept(File arg0) {
            if (arg0.isDirectory()) {
                return true;
            }
            return arg0.getName().endsWith("minecraft.jar");
        }

        public String getDescription() {
            return "Only minecraft.jar";
        }
    }
}

