/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mab.common.commander.EnumTeam;
import mab.common.commander.utils.TeamPacketHandeler;
import net.minecraft.server.MinecraftServer;

public class TeamMap {
    private HashMap teamMap = new HashMap();
    private EnumTeam[] teamList = new EnumTeam[0];
    private long id = -1L;
    private static TeamMap INSTANCE;
    private static String fileName;

    public static TeamMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TeamMap();
        }
        return INSTANCE;
    }

    public static void resetInstance(long id2, EnumTeam[] teams) {
        INSTANCE = new TeamMap();
        TeamMap.INSTANCE.id = id2;
        TeamMap.INSTANCE.teamList = teams;
        TeamMap.INSTANCE.teamMap = new HashMap();
    }

    public static void resetInstance() {
        TeamMap.resetInstance(-1L, new EnumTeam[0]);
    }

    public boolean isGameActive() {
        return this.id != -1L;
    }

    public long getID() {
        return this.id;
    }

    public EnumTeam getTeamForPlayer(qx player) {
        return (EnumTeam)((Object)this.teamMap.get(player.bR));
    }

    public void setTeamForPlayer(qx player, EnumTeam enumTeam) {
        this.teamMap.put(player.bR, enumTeam);
    }

    public boolean isOnSameTeam(qx entity, EnumTeam team) {
        EnumTeam playerTeam = (EnumTeam)((Object)this.teamMap.get(entity.bR));
        if (playerTeam == null) {
            return true;
        }
        return team.equals((Object)playerTeam);
    }

    public TeamPacketHandeler.PlayerIDTeam[] generateList(yc world) {
        ArrayList<TeamPacketHandeler.PlayerIDTeam> playerTeamArray = new ArrayList<TeamPacketHandeler.PlayerIDTeam>();
        for (Map.Entry pairs : this.teamMap.entrySet()) {
            qx player = world.a((String)pairs.getKey());
            if (player == null) continue;
            playerTeamArray.add(new TeamPacketHandeler.PlayerIDTeam(player, (EnumTeam)((Object)pairs.getValue())));
        }
        return playerTeamArray.toArray(new TeamPacketHandeler.PlayerIDTeam[0]);
    }

    public static void load(File worldSave) {
        INSTANCE = new TeamMap();
        File dataPath = new File(worldSave, fileName);
        if (dataPath.exists()) {
            try {
                bq tags = ca.a((InputStream)new FileInputStream(dataPath));
                TeamMap.INSTANCE.id = tags.f("GameID");
                bq teamTag = tags.l("Teams");
                ArrayList<EnumTeam> teamListTemp = new ArrayList<EnumTeam>();
                for (int i = 0; i < 16; ++i) {
                    if (!teamTag.b(String.valueOf(i)) || !teamTag.n(String.valueOf(i))) continue;
                    teamListTemp.add(EnumTeam.values()[i]);
                }
                TeamMap.INSTANCE.teamList = teamListTemp.toArray(new EnumTeam[0]);
                TeamMap.INSTANCE.teamMap = new HashMap();
                bq teamMapTag = tags.l("TeamMap");
                for (cd nextTag : teamMapTag.c()) {
                    if (!(nextTag instanceof bp)) continue;
                    TeamMap.INSTANCE.teamMap.put(nextTag.e(), EnumTeam.values()[((bp)nextTag).a]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void save(File worldSave) {
        File dataPath = new File(worldSave, fileName);
        if (dataPath.exists()) {
            dataPath.delete();
        }
        try {
            ca.a((bq)TeamMap.getInstance().createCompound(), (OutputStream)new FileOutputStream(dataPath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private bq createCompound() {
        bq compound = new bq();
        compound.a("GameID", this.id);
        bq teams = new bq();
        for (int i = 0; i < this.teamList.length; ++i) {
            teams.a(String.valueOf(this.teamList[i].ordinal()), true);
        }
        compound.a("Teams", (cd)teams);
        bq teamMapCompound = new bq();
        for (Map.Entry next : this.teamMap.entrySet()) {
            teamMapCompound.a((String)next.getKey(), (byte)((EnumTeam)((Object)next.getValue())).ordinal());
        }
        compound.a("TeamMap", (cd)teamMapCompound);
        return compound;
    }

    public EnumTeam[] getTeams() {
        return this.teamList;
    }

    public HashMap countTreams() {
        String[] usernames;
        HashMap<EnumTeam, Integer> counts = new HashMap<EnumTeam, Integer>();
        for (EnumTeam team : this.teamList) {
            counts.put(team, 0);
        }
        for (String user : usernames = MinecraftServer.D().A()) {
            EnumTeam team = (EnumTeam)((Object)this.teamMap.get(user));
            if (team == null) continue;
            counts.put(team, (Integer)counts.get((Object)team) + 1);
        }
        return counts;
    }

    public EnumTeam getTeamWithMinPlayers() {
        HashMap counts = this.countTreams();
        EnumTeam minTeam = null;
        int minCount = Integer.MAX_VALUE;
        for (Map.Entry next : counts.entrySet()) {
            if ((Integer)next.getValue() >= minCount) continue;
            minCount = (Integer)next.getValue();
            minTeam = (EnumTeam)((Object)next.getKey());
        }
        return minTeam;
    }

    public void addPlayerToTeam(qx player, EnumTeam playerTeam) {
        this.teamMap.put(player.bR, playerTeam);
    }

    static {
        fileName = "MB-Teams.dat";
    }
}

