/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander.utils;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class Spiral {
    private static final Point ORIGIN = new Point(0, 0);
    private final int width;
    private final int height;
    private Point point;
    private Direction direction = Direction.E;
    private List list = new ArrayList();

    public Spiral(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public List spiral() {
        this.point = ORIGIN;
        int steps = 1;
        while (this.list.size() < this.width * this.height) {
            this.advance(steps);
            this.advance(steps);
            ++steps;
        }
        return this.list;
    }

    private void advance(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.inBounds(this.point)) {
                this.list.add(this.point);
            }
            this.point = this.direction.advance(this.point);
        }
        this.direction = this.direction.next();
    }

    private boolean inBounds(Point p) {
        return Spiral.between(-this.width / 2, this.width / 2, p.x) && Spiral.between(-this.height / 2, this.height / 2, p.y);
    }

    private static boolean between(int low, int high, int n) {
        return low <= n && n <= high;
    }

    static class 1 {
    }

    private static enum Direction {
        E(1, 0){

            @Override
            Direction next() {
                return N;
            }
        }
        ,
        N(0, 1){

            @Override
            Direction next() {
                return W;
            }
        }
        ,
        W(-1, 0){

            @Override
            Direction next() {
                return S;
            }
        }
        ,
        S(0, -1){

            @Override
            Direction next() {
                return E;
            }
        };

        private int dx;
        private int dy;

        Point advance(Point point) {
            return new Point(point.x + this.dx, point.y + this.dy);
        }

        abstract Direction next();

        /*
         * WARNING - void declaration
         */
        private Direction() {
            void dy;
            void dx;
            this.dx = dx;
            this.dy = dy;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        /* synthetic */ Direction(int x0, int x1, 1 x2) {
            this((String)x0, x1, (int)x2, (int)x3);
            void x3;
        }
    }
}

