/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander.npc;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mab.common.commander.CommanderPacketHandeler;
import mab.common.commander.ConfigHelper;
import mab.common.commander.DamageSourceArmourPenatrate;
import mab.common.commander.EnumTeam;
import mab.common.commander.IUpgradeable;
import mab.common.commander.MBCommander;
import mab.common.commander.npc.EnumAbilities;
import mab.common.commander.npc.EnumUnitItems;
import mab.common.commander.npc.EnumUnits;
import mab.common.commander.npc.ai.EntityMBNearestAttackableTarget;
import mab.common.commander.npc.ai.EnumOrder;
import mab.common.commander.npc.ai.MBEntityAIAttackMelee;
import mab.common.commander.npc.ai.MBEntityAIFollow;
import mab.common.commander.npc.ai.MBEntityAIStandGuard;
import mab.common.commander.utils.CommonHelper;
import mab.common.commander.utils.TeamMap;

public abstract class EntityMBUnit
extends mi
implements IUpgradeable,
IEntityAdditionalSpawnData {
    public boolean renderShadow = true;
    private int weaponDrawTimer;
    private int healBonusTimer = 0;
    public static final int MAX_WEAPON_DRAW = 400;
    public static final int NORMAL_HEALRATE = 60;
    public static final int ADVANCED_HEAL_RATE = 60;
    public static final int MORALE_DEGRADE_RATE = 300;
    private int playerDamage = 0;
    private boolean addedTasks = false;
    protected EnumTeam team;
    protected EnumUnits unit;
    protected byte[] options;
    private String owner = "";
    private int moraleCounter = 300;
    private byte current_morale;
    protected double targetDistance = 16.0;

    public EntityMBUnit(yc par1World, EnumTeam team, EnumUnits type) {
        super(par1World);
        this.bH = 0.3f;
        this.a(0.6f, 1.8f);
        this.unit = type;
        this.team = team;
        this.options = new byte[6];
        Arrays.fill(this.options, (byte)-1);
        this.weaponDrawTimer = 400;
        this.ag.a(18, (Object)((byte)this.aT()));
        this.ag.a(19, (Object)0);
        this.ag.a(20, (Object)0);
        this.ag.a(21, (Object)0);
        this.ag.a(26, (Object)1);
        this.ag.a(27, (Object)0);
        this.ag.a(28, (Object)"");
        this.ag.a(29, (Object)-1);
        this.ag.a(30, (Object)-1);
        this.ag.a(31, (Object)-1);
        ReflectionHelper.setPrivateValue(md.class, (Object)this, (Object)new on((md)this, par1World, (float)ConfigHelper.getPathFindSearch()), (int)58);
        this.aR = this.aT();
    }

    public void y() {
        super.y();
        if (this.p.I) {
            this.bF = this.isJumping();
        } else {
            this.setAdjacentClimbBlock(this.checkForAdjacentClimbBlock());
        }
    }

    protected void addAITasks(EnumUnits unit) {
        this.bn.a(1, (nc)new mz((md)this));
        this.bn.a(2, (nc)new MBEntityAIAttackMelee((md)this, this.bH, true));
        this.bn.a(5, (nc)new ns((md)this, true));
        this.bn.a(7, (nc)new MBEntityAIFollow(this, this.bH, 6.0f, 3.5f));
        this.bn.a(8, (nc)new MBEntityAIStandGuard(this, 0.25f));
        this.bn.a(9, (nc)new nh((md)this, qx.class, 8.0f));
        this.bn.a(9, (nc)new nv((md)this));
        this.bo.a(2, (nc)new EntityMBNearestAttackableTarget((md)this, 16.0f, 0, false));
        this.az().b(true);
    }

    protected void a() {
        super.a();
        this.moraleCounter = 300;
    }

    public float bB() {
        float morale = (float)this.current_morale / 100.0f;
        return super.bB() + 0.1f * morale;
    }

    public boolean be() {
        return true;
    }

    protected void bm() {
        super.bm();
        if (!this.addedTasks) {
            this.addAITasks(this.getUnitType());
            this.addedTasks = true;
            this.az().c(true);
        }
        if (this.aG() == null && this.aV == 0) {
            if (this.weaponDrawTimer > 0) {
                --this.weaponDrawTimer;
            } else if (this.playerDamage > 0) {
                --this.playerDamage;
            }
        } else {
            this.weaponDrawTimer = 400;
        }
        if (this.moraleCounter > 0) {
            --this.moraleCounter;
        } else {
            byte morale = this.getCurrentMorale();
            if (morale > -100) {
                this.ag.b(20, (Object)((byte)(morale - 1)));
            }
            this.moraleCounter = 300;
        }
        if (this.weaponDrawTimer == 0 && this.isWeaponsDrawn()) {
            this.ag.b(26, (Object)0);
        } else if (this.weaponDrawTimer > 0 && !this.isWeaponsDrawn()) {
            this.ag.b(26, (Object)1);
        }
        if (this.weaponDrawTimer == 0) {
            if (this.healBonusTimer > 0) {
                if (this.ab % 60 == 0) {
                    this.i(1);
                }
            } else if (this.ab % 60 == 0) {
                this.i(1);
            }
        }
        if (this.healBonusTimer > 0) {
            --this.healBonusTimer;
        }
        this.ag.b(18, (Object)((byte)this.aU()));
        if (this.ab % 100 == 0 && this.getOrder() == EnumOrder.Follow && this.p.a(this.ag.e(28)) == null) {
            this.setOrder(EnumOrder.StandGuard, new int[]{(int)Math.floor(this.t), (int)Math.floor(this.u), (int)Math.floor(this.v)}, "");
        }
        if (this.aG() != null && this.aG().L) {
            this.b(null);
        }
    }

    public void c() {
        this.bo();
        this.current_morale = this.calculateCurrentMorale();
        super.c();
    }

    @Override
    public abstract EnumUnits[] getUpgrades();

    public boolean isWeaponsDrawn() {
        return this.ag.a(26) == 1;
    }

    public abstract int getAttackStrength();

    public int getAttackStrengthBonus() {
        byte morale = this.current_morale;
        if (morale > 50) {
            return 1;
        }
        if (morale >= -50) {
            return 0;
        }
        return -1;
    }

    public abstract int getBaseArmour();

    public int getArmourBonus() {
        byte morale = this.current_morale;
        if (morale > 75) {
            return 2;
        }
        if (morale > 25) {
            return 1;
        }
        if (morale >= -25) {
            return 0;
        }
        if (morale >= -75) {
            return -1;
        }
        return -2;
    }

    public int aW() {
        return this.getBaseArmour() + this.getArmourBonus();
    }

    public String getUnitName() {
        return this.unit.getFullName();
    }

    public void b(bq par1nbtTagCompound) {
        int i;
        super.b(par1nbtTagCompound);
        par1nbtTagCompound.a("team", (byte)this.team.ordinal());
        par1nbtTagCompound.a("unit", (byte)this.unit.ordinal());
        par1nbtTagCompound.a("exp", this.ag.a(19));
        par1nbtTagCompound.a("morale", this.ag.a(20));
        for (i = 0; i < 6; ++i) {
            par1nbtTagCompound.a("Option" + i, this.getOption(i));
        }
        par1nbtTagCompound.a("order", this.ag.a(27));
        for (i = 0; i < 3; ++i) {
            par1nbtTagCompound.a("order data" + i, this.ag.c(29 + i));
        }
        par1nbtTagCompound.a("order data string", this.ag.e(28));
    }

    public void a(bq par1nbtTagCompound) {
        int i;
        super.a(par1nbtTagCompound);
        this.team = EnumTeam.values()[par1nbtTagCompound.c("team")];
        this.unit = EnumUnits.values()[par1nbtTagCompound.c("unit")];
        this.ag.b(19, (Object)par1nbtTagCompound.c("exp"));
        this.ag.b(20, (Object)par1nbtTagCompound.c("morale"));
        for (i = 0; i < 6; ++i) {
            this.setOption(i, par1nbtTagCompound.c("Option" + i));
        }
        this.ag.b(27, (Object)par1nbtTagCompound.c("order"));
        for (i = 0; i < 3; ++i) {
            this.ag.b(29 + i, (Object)par1nbtTagCompound.e("order data" + i));
        }
        this.ag.b(28, (Object)par1nbtTagCompound.i("order data string"));
        this.addAITasks(this.getUnitType());
    }

    public final byte getOptionMax(int option) {
        return (byte)this.unit.getOptionMax()[option];
    }

    public final String getOptionLabel(int option) {
        return EnumUnits.labels[this.unit.getOptionIcons()[option]];
    }

    public final int getOptionIcon(int option) {
        return this.unit.getOptionIcons()[option];
    }

    public byte getOption(int option) {
        return this.options[option];
    }

    public byte getCurrentHealth() {
        return this.ag.a(18);
    }

    public byte getCurrentExperience() {
        return this.ag.a(19);
    }

    public byte getCurrentMorale() {
        return this.ag.a(20);
    }

    public byte calculateCurrentMorale() {
        byte morale = this.getCurrentMorale();
        List entities = this.p.b((lq)this, this.D.b(16.0, 16.0, 16.0));
        int bonus = 0;
        boolean allowDifferetTeam = !MBCommander.config.get("Unit_Options", "Attack_Other_Teams", false).getBoolean(false);
        for (lq entity : entities) {
            if (entity instanceof EntityMBUnit) {
                if (allowDifferetTeam || ((EntityMBUnit)entity).getTeam() == this.team) {
                    bonus += ((EntityMBUnit)entity).getUnitType().getTier() * 3;
                    continue;
                }
                bonus -= ((EntityMBUnit)entity).getUnitType().getTier() * 3;
                continue;
            }
            if (entity instanceof qx) {
                if (CommonHelper.isTeamGame()) {
                    if (this.p.I) {
                        if (TeamMap.getInstance().isOnSameTeam((qx)entity, this.getTeam())) {
                            bonus += 10;
                            continue;
                        }
                        bonus -= 10;
                        continue;
                    }
                    if (entity.getEntityData().b("MB-Team") && entity.getEntityData().c("MB-Team") == this.getTeam().ordinal()) {
                        bonus += 10;
                        continue;
                    }
                    bonus -= 10;
                    continue;
                }
                bonus += 10;
                continue;
            }
            if (!(entity instanceof qe)) continue;
            bonus -= 5;
        }
        return (byte)Math.max(Math.min(morale + bonus, 100), -100);
    }

    @Override
    public EnumTeam getTeam() {
        return this.team;
    }

    public EnumUnits getUnitType() {
        return this.unit;
    }

    public EnumOrder getOrder() {
        return EnumOrder.values()[this.ag.a(27)];
    }

    public int[] getOrderData() {
        return new int[]{this.ag.c(29), this.ag.c(30), this.ag.c(31)};
    }

    public void setOption(int option, byte value) {
        this.options[option] = value;
    }

    public String getSkinFile() {
        return MBCommander.IMAGE_FOLDER + "skins/Body (" + this.getOption(0) + ").png";
    }

    public String getHairFile() {
        return MBCommander.IMAGE_FOLDER + "skins/Hair (" + this.getOption(1) + ").png";
    }

    public String getEyesFile() {
        return MBCommander.IMAGE_FOLDER + "skins/Eyes (" + this.getOption(2) + ").png";
    }

    @SideOnly(value=Side.CLIENT)
    public float R() {
        if (this.renderShadow) {
            return super.R();
        }
        return 0.0f;
    }

    public abstract EnumUnitItems getWeaponOption();

    public abstract EnumUnitItems getWeaponOffHandOption();

    public abstract int getHelmNumber();

    public static EntityMBUnit generateUnit(yc world, EnumTeam team, EnumUnits unit) {
        try {
            return (EntityMBUnit)unit.getUnitClass().getConstructor(yc.class, EnumTeam.class, EnumUnits.class).newInstance(new Object[]{world, team, unit});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getDisplayOrder() {
        String postfix = null;
        EnumOrder order = this.getOrder();
        switch (order) {
            case Follow: {
                lq e = this.p.a(this.ag.c(29));
                if (!(e instanceof qx) && e != null) break;
                postfix = this.ag.e(28);
            }
        }
        postfix = null;
        return this.getOrder().getTranslatedLabel(postfix);
    }

    public String getOrderStringData() {
        return this.ag.e(28);
    }

    public boolean a(qx player) {
        ur stack = player.bD();
        if (stack != null) {
            if (stack.b() instanceof va) {
                if (!va.g((int)stack.j())) {
                    if (!this.p.I) {
                        List effects = ((va)stack.b()).g(stack);
                        for (lm potionEffect : effects) {
                            this.d(new lm(potionEffect.a(), potionEffect.b(), potionEffect.c()));
                        }
                    }
                    if (!player.cd.d) {
                        player.bJ.a(player.bJ.c, 1);
                        player.bJ.a(new ur(up.bt));
                    }
                    this.p.a((lq)this, "random.drink", 0.5f, this.p.t.nextFloat() * 0.1f + 0.9f);
                    return true;
                }
                return false;
            }
            if (stack.b() instanceof uk) {
                if (!this.p.I) {
                    uk food = (uk)stack.b();
                    if (food.cj == up.bm.cj) {
                        this.ag.b(20, (Object)((byte)Math.max(this.getCurrentMorale() - (byte)(food.g() * 30), -100)));
                    } else {
                        this.ag.b(20, (Object)((byte)Math.min(this.getCurrentMorale() + (byte)(food.g() * 10), 100)));
                    }
                    if (!player.cd.d) {
                        player.bJ.a(player.bJ.c, 1);
                    }
                }
                this.p.a((lq)this, "random.eat", 0.5f + 0.5f * (float)this.aa.nextInt(2), (this.aa.nextFloat() - this.aa.nextFloat()) * 0.2f + 1.0f);
            }
        }
        return false;
    }

    public void setOrder(EnumOrder order, int[] data, String stringData) {
        this.ag.b(27, (Object)((byte)order.ordinal()));
        for (int i = 0; i < 3 && i < data.length; ++i) {
            this.ag.b(29 + i, (Object)data[i]);
        }
        this.ag.b(28, (Object)stringData);
    }

    public boolean m(lq par1Entity) {
        boolean var4;
        int var6 = this.getArmourPenatratingDamage();
        int var2 = this.getAttackStrength() - var6 + this.getAttackStrengthBonus();
        if (this.a(ll.g)) {
            var2 += 3 << this.b(ll.g).c();
        }
        if (this.a(ll.t)) {
            var2 -= 2 << this.b(ll.t).c();
        }
        int var3 = 0;
        if (par1Entity instanceof md) {
            var2 += xe.a((md)this, (md)((md)par1Entity));
            var3 += xe.b((md)this, (md)((md)par1Entity));
        }
        if (var4 = par1Entity.a(lh.a((md)this), var2)) {
            int var5;
            this.bH();
            this.ag.b(19, (Object)((byte)Math.min(this.getCurrentExperience() + this.getExperiencePerHit(), 100)));
            if (var3 > 0) {
                par1Entity.g((double)(-ke.a((float)(this.z * (float)Math.PI / 180.0f)) * (float)var3 * 0.5f), 0.1, (double)(ke.b((float)(this.z * (float)Math.PI / 180.0f)) * (float)var3 * 0.5f));
                this.w *= 0.6;
                this.y *= 0.6;
            }
            if ((var5 = xe.a((md)((md)par1Entity))) > 0) {
                par1Entity.c(var5 * 4);
            }
            if (var6 > 0) {
                par1Entity.ae = 0;
                par1Entity.a((lh)new DamageSourceArmourPenatrate((lq)this), var6);
            }
            if (!this.p.I && !par1Entity.S()) {
                this.addToMorale(10);
                List units = this.getSurroundingTeamUnits();
                for (EntityMBUnit entityMBUnit : units) {
                    entityMBUnit.addToMorale(3);
                }
            }
        }
        return var4;
    }

    public void addToMorale(int i) {
        this.ag.b(20, (Object)((byte)Math.min(i + this.getCurrentMorale(), 100)));
    }

    protected abstract byte getExperiencePerHit();

    public abstract byte getCost();

    public int aT() {
        return 0;
    }

    protected boolean bj() {
        return false;
    }

    @Override
    public int getFirstEditableOptionIndex() {
        return 3;
    }

    @Override
    public di generatePacket(EntityMBUnit unit, qx player) {
        return CommanderPacketHandeler.generateUpgradePacket(this, unit, player);
    }

    @Override
    public EntityMBUnit getDefaltUnit() {
        return this;
    }

    public EnumAbilities[] getAbilities() {
        return new EnumAbilities[0];
    }

    @Override
    public byte getDefaultOption(int i) {
        if (i > 2) {
            return 0;
        }
        return this.getOption(i);
    }

    public static EntityMBUnit generateUnit(yc world, EnumTeam team, EnumUnits enumUnits, IUpgradeable upgradeable) {
        EntityMBUnit unit = EntityMBUnit.generateUnit(world, team, enumUnits);
        if (upgradeable instanceof EntityMBUnit) {
            EntityMBUnit prev = (EntityMBUnit)upgradeable;
            for (int i = 0; i < 3; ++i) {
                unit.setOption(i, prev.getOption(i));
            }
        }
        return unit;
    }

    public int getArmourPenatratingDamage() {
        return 0;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeByte((int)((byte)this.team.ordinal()));
        data.writeByte((int)((byte)this.unit.ordinal()));
        for (int i = 0; i < this.options.length; ++i) {
            data.writeByte((int)this.options[i]);
        }
        data.writeUTF(this.owner);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.team = EnumTeam.values()[data.readByte()];
        this.unit = EnumUnits.values()[data.readByte()];
        for (int i = 0; i < 6; ++i) {
            this.options[i] = data.readByte();
        }
        this.owner = data.readUTF();
    }

    public void setOwner(String username) {
        this.owner = username;
    }

    public String an() {
        System.out.println(super.an());
        return bn.a().b(this.getUnitName());
    }

    public String getOwner() {
        return this.owner;
    }

    protected int getBonusExperience() {
        byte morale = this.current_morale;
        if (morale >= 50) {
            return 1;
        }
        if (morale < -50) {
            return -1;
        }
        return 0;
    }

    public List getSurroundingTeamUnits() {
        boolean teams = MBCommander.config.get("Unit_Options", "Attack_Other_Teams", false).getBoolean(false);
        ArrayList<EntityMBUnit> units = new ArrayList<EntityMBUnit>();
        List entities = this.p.b((lq)this, this.D.b(16.0, 16.0, 16.0));
        for (lq entity : entities) {
            if (!(entity instanceof EntityMBUnit) || teams && !this.getTeam().equals((Object)((EntityMBUnit)entity).getTeam())) continue;
            units.add((EntityMBUnit)entity);
        }
        return units;
    }

    public void a(lh par1DamageSource) {
        if (!this.p.I) {
            List units = this.getSurroundingTeamUnits();
            for (EntityMBUnit entityMBUnit : units) {
                entityMBUnit.addToMorale(-2 * entityMBUnit.getUnitType().getTier());
            }
        }
        super.a(par1DamageSource);
    }

    public boolean isEnemy(lq entity, boolean filterCreative) {
        if (CommonHelper.isTeamGame()) {
            if (!(!(entity instanceof qx) || ((qx)entity).cd.d && filterCreative)) {
                return !TeamMap.getInstance().isOnSameTeam((qx)entity, this.getTeam());
            }
            if (entity instanceof EntityMBUnit) {
                return !((EntityMBUnit)entity).getTeam().equals((Object)this.getTeam());
            }
        }
        return entity instanceof md && entity instanceof qe && !(entity instanceof qc);
    }

    public boolean isEnemy(lq entity) {
        return this.isEnemy(entity, true);
    }

    public byte getCurrentMoraleWithBonus() {
        return this.current_morale;
    }

    public byte getBaseMorale() {
        return this.ag.a(20);
    }

    public void setBaseMorale(byte morale) {
        this.ag.b(20, (Object)morale);
    }

    public boolean a(lh s, int par2) {
        if (s.f() instanceof md && s.f().k != this.k) {
            if (s.f() instanceof qx) {
                this.playerDamage += par2;
                if (this.playerDamage > 10 && !((qx)s.f()).cd.d) {
                    this.b((md)s.f());
                }
            } else {
                this.b((md)s.g());
            }
        }
        return super.a(s, par2);
    }

    public float getTurnRate() {
        return 30.0f;
    }

    public boolean g_() {
        return this.isAdjacentClimbBlock();
    }

    private boolean isJumping() {
        return this.ag.a(21) % 2 == 1;
    }

    public boolean isAdjacentClimbBlock() {
        return this.ag.a(21) / 2 % 2 == 1;
    }

    public boolean isHoldingOntoLadder() {
        return this.ag.a(21) > 3;
    }

    private void updateMiscDataWatcher(boolean jump, boolean nextTo, boolean isHolding) {
        if (!this.p.I) {
            byte value = 0;
            if (jump) {
                value = 1;
            }
            if (nextTo) {
                value = (byte)(value | 2);
            }
            if (isHolding) {
                value = (byte)(value | 4);
            }
            this.ag.b(21, (Object)value);
        }
    }

    public void e(boolean var1) {
        super.e(var1);
        this.updateMiscDataWatcher(var1, this.isAdjacentClimbBlock(), this.isHoldingOntoLadder());
    }

    public void setAdjacentClimbBlock(boolean nextTo) {
        this.updateMiscDataWatcher(this.isJumping(), nextTo, this.isHoldingOntoLadder());
    }

    public void setHoldingOntoLadder(boolean isHolding) {
        this.updateMiscDataWatcher(this.isJumping(), this.isAdjacentClimbBlock(), isHolding);
    }

    public boolean checkForAdjacentClimbBlock() {
        int var3;
        int var2;
        int var1 = ke.c((double)this.t);
        int var4 = this.p.a(var1, var2 = ke.c((double)this.D.b), var3 = ke.c((double)this.v));
        return amq.p[var4] != null && amq.p[var4].isLadder(this.p, var1, var2, var3);
    }

    public double getTargetDist() {
        return this.targetDistance;
    }

    public double getNormalTargetDistance() {
        return 16.0;
    }

    public double getNearTargetDistance() {
        return 8.0;
    }

    public void setTargetDistance(double target) {
        this.targetDistance = target;
    }

    public void setTargetDistance(EnumOrder order) {
        switch (order) {
            case TargetNormal: {
                this.setTargetDistance(this.getNormalTargetDistance());
                break;
            }
            case TargetNear: {
                this.setTargetDistance(this.getNearTargetDistance());
                break;
            }
            case TargetNone: {
                this.setTargetDistance(0.0);
                break;
            }
        }
    }
}

