/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander.npc;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mab.common.commander.EnumTeam;
import mab.common.commander.MBCommander;
import mab.common.commander.npc.EntityMBUnit;
import mab.common.commander.npc.EnumAbilities;
import mab.common.commander.npc.EnumUnitItems;
import mab.common.commander.npc.EnumUnits;
import mab.common.commander.npc.ai.EntityMBNearestAttackableTarget;
import mab.common.commander.npc.ai.MBEntityAIAttackMelee;
import mab.common.commander.npc.ai.MBEntityAIFollow;
import mab.common.commander.npc.ai.MBEntityAIStandGuard;

public class EntityMBMeleeUnit
extends EntityMBUnit {
    private static EnumUnitItems[] militaWeapons = new EnumUnitItems[]{EnumUnitItems.StoneSword, EnumUnitItems.StoneSword, EnumUnitItems.StoneAxe, EnumUnitItems.WoodMace, EnumUnitItems.StoneMace, EnumUnitItems.WoodSpear, EnumUnitItems.StoneSpear, EnumUnitItems.PitchFork};
    private static EnumUnitItems[] oneHandWeapons = new EnumUnitItems[]{EnumUnitItems.IronSword, EnumUnitItems.IronBattleaxe, EnumUnitItems.IronMace};
    private static EnumUnitItems[] spearWeapons = new EnumUnitItems[]{EnumUnitItems.IronSpear, EnumUnitItems.IronHalberard, EnumUnitItems.IronGlaive};
    private static EnumUnitItems[] shield1 = new EnumUnitItems[]{EnumUnitItems.WoodShield, EnumUnitItems.HideShield, EnumUnitItems.HideShiedPaint};
    private static EnumUnitItems[] shield2 = new EnumUnitItems[]{EnumUnitItems.IronShieldPaint, EnumUnitItems.DiamondShieldPaint, EnumUnitItems.GoldShieldPaint};
    private static EnumUnits[] militiaUpgrades = new EnumUnits[]{EnumUnits.ManAtArms, EnumUnits.Spearman};
    private static EnumUnits[] manatarmsUpgrades = new EnumUnits[]{EnumUnits.KnightShield, EnumUnits.KnightDuel};
    private static EnumUnits[] spearmanUpgrades = new EnumUnits[]{EnumUnits.KnightSpear};

    public EntityMBMeleeUnit(yc par1World) {
        this(par1World, EnumTeam.values()[par1World.t.nextInt(16)], EnumUnits.Militia);
    }

    public EntityMBMeleeUnit(yc par1World, EnumTeam team, EnumUnits type) {
        super(par1World, team, type);
    }

    @SideOnly(value=Side.CLIENT)
    public String O() {
        switch (this.getUnitType()) {
            case Militia: {
                return MBCommander.IMAGE_FOLDER + "skins/units/milita/Militia (" + this.getTeam().ordinal() + ").png";
            }
            case ManAtArms: 
            case Spearman: {
                return MBCommander.IMAGE_FOLDER + "skins/units/footman/Footman (" + this.getTeam().ordinal() + ").png";
            }
            case KnightShield: 
            case KnightDuel: 
            case KnightSpear: {
                return MBCommander.IMAGE_FOLDER + "skins/units/knight/Knight (" + this.getTeam().ordinal() + ").png";
            }
        }
        return "";
    }

    @Override
    public int getAttackStrength() {
        switch (this.getUnitType()) {
            case Militia: {
                return 4;
            }
            case ManAtArms: 
            case Spearman: {
                return 6;
            }
            case KnightShield: 
            case KnightSpear: {
                return 8;
            }
            case KnightDuel: {
                return 9;
            }
        }
        return 0;
    }

    @Override
    public EnumUnitItems getWeaponOption() {
        switch (this.getUnitType()) {
            case Militia: {
                return militaWeapons[this.getOption(3)];
            }
            case ManAtArms: 
            case KnightShield: 
            case KnightDuel: {
                return oneHandWeapons[this.getOption(3)];
            }
            case Spearman: 
            case KnightSpear: {
                return spearWeapons[this.getOption(3)];
            }
        }
        return null;
    }

    @Override
    public EnumUnitItems getWeaponOffHandOption() {
        switch (this.getUnitType()) {
            case ManAtArms: 
            case Spearman: {
                return shield1[this.getOption(4)];
            }
            case KnightShield: 
            case KnightSpear: {
                return shield2[this.getOption(4)];
            }
            case KnightDuel: {
                return oneHandWeapons[this.getOption(4)];
            }
        }
        return null;
    }

    @Override
    public int getHelmNumber() {
        if (this.unit == EnumUnits.Militia) {
            return this.getOption(4) - 1;
        }
        return this.getOption(5) - 1;
    }

    @Override
    protected byte getExperiencePerHit() {
        switch (this.getUnitType()) {
            case Militia: {
                return (byte)(5 + this.getBonusExperience());
            }
            case ManAtArms: 
            case Spearman: {
                return (byte)(3 + this.getBonusExperience());
            }
        }
        return 0;
    }

    @Override
    public byte getCost() {
        switch (this.getUnitType()) {
            case Militia: {
                return 2;
            }
            case ManAtArms: 
            case Spearman: {
                return 3;
            }
            case KnightShield: 
            case KnightDuel: 
            case KnightSpear: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public int aT() {
        try {
            switch (this.getUnitType()) {
                case Militia: {
                    return 20;
                }
                case ManAtArms: 
                case Spearman: {
                    return 25;
                }
                case KnightShield: 
                case KnightDuel: 
                case KnightSpear: {
                    return 30;
                }
            }
            return 0;
        }
        catch (NullPointerException e) {
            return 15;
        }
    }

    @Override
    public int getBaseArmour() {
        switch (this.getUnitType()) {
            case Militia: {
                return 4;
            }
            case ManAtArms: 
            case Spearman: {
                return 8;
            }
            case KnightShield: {
                return 15;
            }
            case KnightSpear: {
                return 13;
            }
            case KnightDuel: {
                return 12;
            }
        }
        return 0;
    }

    @Override
    public int getArmourPenatratingDamage() {
        if (this.getUnitType() == EnumUnits.KnightDuel) {
            return 2;
        }
        return 0;
    }

    @Override
    public EnumAbilities[] getAbilities() {
        switch (this.getUnitType()) {
            case Spearman: {
                return new EnumAbilities[]{EnumAbilities.ExtendedReach, EnumAbilities.SlowAttack};
            }
            case KnightShield: {
                return new EnumAbilities[]{EnumAbilities.ArrowBlock};
            }
            case KnightDuel: {
                return new EnumAbilities[]{EnumAbilities.ArmourPenatrate, EnumAbilities.Leap};
            }
            case KnightSpear: {
                return new EnumAbilities[]{EnumAbilities.ExtendedReach, EnumAbilities.SlowAttack, EnumAbilities.ArrowBlock};
            }
        }
        return super.getAbilities();
    }

    @Override
    public boolean a(lh par1DamageSource, int par2) {
        System.out.println(par2);
        EnumUnits unit = this.getUnitType();
        if ((unit == EnumUnits.KnightShield || unit == EnumUnits.KnightSpear) && par1DamageSource.a()) {
            return super.a(par1DamageSource, (int)((float)par2 * 0.75f));
        }
        boolean a = super.a(par1DamageSource, par2);
        System.out.println("M: " + par2 + " of " + this.aU());
        return a;
    }

    @Override
    protected void addAITasks(EnumUnits type) {
        this.bn.a(1, (nc)new mz((md)this));
        if (type == EnumUnits.Spearman) {
            this.bn.a(2, (nc)new MBEntityAIAttackMelee((md)this, this.bH, true, 45, 4.0f));
            this.bn.a(7, (nc)new MBEntityAIFollow(this, this.bH, 6.0f, 4.5f));
        } else if (type == EnumUnits.KnightSpear) {
            this.bn.a(2, (nc)new MBEntityAIAttackMelee((md)this, this.bH, true, 40, 4.0f));
            this.bn.a(7, (nc)new MBEntityAIFollow(this, this.bH, 6.0f, 4.5f));
        } else if (type == EnumUnits.KnightDuel) {
            this.bn.a(2, (nc)new ng((md)this, 0.4f));
            this.bn.a(3, (nc)new MBEntityAIAttackMelee((md)this, this.bH, true));
            this.bn.a(7, (nc)new MBEntityAIFollow(this, this.bH, 5.0f, 3.5f));
        } else {
            this.bn.a(2, (nc)new MBEntityAIAttackMelee((md)this, this.bH, true));
            this.bn.a(7, (nc)new MBEntityAIFollow(this, this.bH, 5.0f, 3.5f));
        }
        this.bn.a(5, (nc)new ns((md)this, true));
        this.bn.a(8, (nc)new MBEntityAIStandGuard(this, 0.0f));
        this.bn.a(9, (nc)new nh((md)this, qx.class, 8.0f));
        this.bn.a(9, (nc)new nv((md)this));
        this.bo.a(2, (nc)new EntityMBNearestAttackableTarget((md)this, 16.0f, 0, true));
    }

    @Override
    public EnumUnits[] getUpgrades() {
        switch (this.getUnitType()) {
            case Militia: {
                return militiaUpgrades;
            }
            case ManAtArms: {
                return manatarmsUpgrades;
            }
            case Spearman: {
                return spearmanUpgrades;
            }
        }
        return new EnumUnits[0];
    }
}

