/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IChatListener;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import mab.common.commander.CommanderPacketHandeler;
import mab.common.commander.CommonProxy;
import mab.common.commander.ConfigHelper;
import mab.common.commander.block.BlockBanner;
import mab.common.commander.block.BlockItemBanner;
import mab.common.commander.block.TileEntityBanner;
import mab.common.commander.commands.MBRestartGame;
import mab.common.commander.commands.MBStartGame;
import mab.common.commander.commands.MBStopGame;
import mab.common.commander.items.ItemTrumpet;
import mab.common.commander.npc.EntityMBMeleeUnit;
import mab.common.commander.utils.MBChatListener;
import mab.common.commander.utils.MBCommanderForgeEvents;
import mab.common.commander.utils.MBCraftingHandeler;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(name="Mine & Blade: Commander", modid="MaB-Commander", version="0.0.6", acceptedMinecraftVersions="1.4.4")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, channels={"MBc|Banner", "MBc|Spawn", "MBc|Upgrade", "MBc|Order", "MBc|Team", "MBc|Particle"}, packetHandler=CommanderPacketHandeler.class)
public class MBCommander {
    @Mod.Instance(value="MaB-Commander")
    public static MBCommander INSTANCE;
    @SidedProxy(clientSide="mab.client.commander.ClientProxy", serverSide="mab.common.commander.CommonProxy")
    public static CommonProxy PROXY;
    public static String IMAGE_FOLDER;
    public static String ImageSheet;
    public static Configuration config;
    public BlockBanner banner;
    public ItemTrumpet trumpet;

    @Mod.PreInit
    public void PreInitialization(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.addCustomCategoryComment("GAMEPLAY", "Global Gameplay Options");
        config.addCustomCategoryComment("Unit_Options", "Any configuration options to do with units or unit AI");
        config.addCustomCategoryComment("Unit_IDs", "The Entity IDs for the units");
        ConfigHelper.getPathFindSearch();
    }

    @Mod.Init
    public void Initialization(FMLInitializationEvent event) {
        this.banner = new BlockBanner(config.getBlock("Banner", 2650).getInt());
        this.trumpet = new ItemTrumpet(config.getItem("Trumpet", 5000).getInt());
        GameRegistry.registerBlock((amq)this.banner);
        GameRegistry.registerTileEntity(TileEntityBanner.class, (String)"MBBanner");
        up.e[this.banner.cm] = null;
        up.e[this.banner.cm] = new BlockItemBanner(this.banner.cm - 256).b("banner");
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)new MBCommanderForgeEvents());
        EntityRegistry.registerModEntity(EntityMBMeleeUnit.class, (String)"M&B_Unit", (int)config.get("Unit_IDs", "MBMeleeUnit", 212).getInt(), (Object)this, (int)50, (int)3, (boolean)true);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(EntityMBMeleeUnit.class, false);
        GameRegistry.addRecipe((ur)new ur((up)this.trumpet), (Object[])new Object[]{"# ", " #", Character.valueOf('#'), up.o});
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ur)new ur((amq)this.banner, 1, i), (Object[])new Object[]{"#", "#", "S", Character.valueOf('#'), new ur(amq.ae, 1, 15 - i), Character.valueOf('S'), up.D});
            for (int j = 0; j < 16; ++j) {
                GameRegistry.addShapelessRecipe((ur)new ur((amq)this.banner, 1, i), (Object[])new Object[]{new ur(up.aW, 1, i), new ur((amq)this.banner, 1, j)});
            }
        }
    }

    @Mod.PostInit
    public void PostInitialization(FMLPostInitializationEvent event) {
        PROXY.registerRenderInformation();
        PROXY.loadLanguages();
        PROXY.registerPlayerTracker();
        NetworkRegistry.instance().registerChatListener((IChatListener)new MBChatListener());
        config.save();
        GameRegistry.registerCraftingHandler((ICraftingHandler)new MBCraftingHandeler());
    }

    @Mod.ServerStarting
    public void ServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((y)new MBStartGame());
        event.registerServerCommand((y)new MBRestartGame());
        event.registerServerCommand((y)new MBStopGame());
    }

    static {
        IMAGE_FOLDER = "/mab/images/";
        ImageSheet = IMAGE_FOLDER + "MBSheet.png";
    }
}

