/*
 * Decompiled with CFR 0.152.
 */
package mab.common.commander;

import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import mab.common.commander.EnumTeam;
import mab.common.commander.MBCommander;
import mab.common.commander.block.TileEntityBanner;
import mab.common.commander.npc.EntityMBUnit;
import mab.common.commander.npc.EnumUnits;
import mab.common.commander.npc.ai.EnumOrder;
import mab.common.commander.utils.CommonHelper;
import mab.common.commander.utils.TeamPacketHandeler;

public class CommanderPacketHandeler
implements IPacketHandler {
    public static String BannerPacket = "MBc|Banner";
    public static String spawnPacket = "MBc|Spawn";
    public static String upgradePacket = "MBc|Upgrade";
    public static String orderPacket = "MBc|Order";
    public static String particlePacket = "MBc|Particle";
    public static String teamPacket = "MBc|Team";

    public void onPacketData(ce manager, di packet, Player player) {
        qx entityPlayer = (qx)player;
        if (packet.a.equals(BannerPacket)) {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.c));
            try {
                entityPlayer.p.a(inputStream.readInt(), inputStream.readInt(), inputStream.readInt(), (any)new TileEntityBanner(inputStream.readByte(), EnumTeam.values()[inputStream.readByte()]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (packet.a.equals(spawnPacket)) {
            EntityMBUnit unit = CommanderPacketHandeler.readUnitFromPacket(packet, entityPlayer.p, entityPlayer);
            entityPlayer.p.d((lq)unit);
        } else if (packet.a.equals(upgradePacket)) {
            CommanderPacketHandeler.readAndProcessUpgradePacket(packet, entityPlayer.p, entityPlayer);
        } else if (packet.a.equals(orderPacket)) {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(packet.c));
            try {
                int i;
                int playerID = inputStream.readInt();
                EnumOrder order = EnumOrder.values()[inputStream.readByte()];
                int size = inputStream.readByte();
                int[] data = new int[3];
                String stringData = "";
                EntityMBUnit[] units = new EntityMBUnit[size];
                for (i = 0; i < size; ++i) {
                    lq e = entityPlayer.p.a(inputStream.readInt());
                    if (e != null && e instanceof EntityMBUnit) {
                        units[i] = (EntityMBUnit)e;
                        continue;
                    }
                    System.out.println("Mine & Blade: Unexpected Entity ID in Order Packet");
                }
                System.out.println((Object)order);
                if (order == EnumOrder.GoTo) {
                    for (i = 0; i < 3; ++i) {
                        data[i] = inputStream.readInt();
                    }
                    CommonHelper.findAndSetGotoPos(units, data);
                    units[0].setOrder(EnumOrder.StandGuard, data, "");
                }
                if (order == EnumOrder.TargetNormal || order == EnumOrder.TargetNear || order == EnumOrder.TargetNone) {
                    for (i = 0; i < size; ++i) {
                        units[i].setTargetDistance(order);
                        units[i].b(null);
                    }
                }
                for (i = 0; i < size; ++i) {
                    order.setOrderFromPacketData(units[i], entityPlayer);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (packet.a.equals(particlePacket)) {
            this.readAndProcessParticlerPacket(packet, entityPlayer, entityPlayer.p);
        } else if (packet.a.equals(teamPacket)) {
            TeamPacketHandeler.readAndProcessTeamPacket(packet, entityPlayer);
        }
    }

    private void readAndProcessParticlerPacket(di p, qx entityPlayer, yc world) {
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(p.c));
        try {
            byte type = inputStream.readByte();
            switch (type) {
                case 0: {
                    lq e = world.a(inputStream.readInt());
                    if (e == null) break;
                    for (int var1 = 0; var1 < 20; ++var1) {
                        double var8 = world.t.nextGaussian() * 0.02;
                        double var4 = world.t.nextGaussian() * 0.02;
                        double var6 = world.t.nextGaussian() * 0.02;
                        world.a("explode", e.t + (double)(world.t.nextFloat() * e.N * 2.0f) - (double)e.N, e.u + (double)(world.t.nextFloat() * e.O), e.v + (double)(world.t.nextFloat() * e.N * 2.0f) - (double)e.N, var8, var4, var6);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static di generateUpgradePacket(EntityMBUnit previousUnit, EntityMBUnit unit, qx player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(15);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(previousUnit.k);
            outputStream.writeByte((byte)unit.getUnitType().ordinal());
            for (int i = 0; i < 6; ++i) {
                outputStream.writeByte(unit.getOption(i));
            }
            outputStream.writeInt(player.k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new di(upgradePacket, bos.toByteArray());
    }

    public static void readAndProcessUpgradePacket(di p, yc world, qx player) {
        if (p.a.equals(upgradePacket)) {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(p.c));
            try {
                lq e = world.a(inputStream.readInt());
                if (e != null && e instanceof EntityMBUnit) {
                    EntityMBUnit previous = (EntityMBUnit)e;
                    EntityMBUnit unit = EntityMBUnit.generateUnit(world, previous.getTeam(), EnumUnits.values()[inputStream.readByte()]);
                    unit.b(previous.t, previous.u, previous.v, previous.z, previous.A);
                    unit.setOrder(previous.getOrder(), previous.getOrderData(), previous.getOrderStringData());
                    unit.setBaseMorale(previous.getBaseMorale());
                    previous.x();
                    PacketDispatcher.sendPacketToAllAround((double)unit.t, (double)unit.u, (double)unit.v, (double)30.0, (int)unit.aq, (ef)CommanderPacketHandeler.generateParticleEffectPacket((byte)0, (lq)previous));
                    for (int i = 0; i < 6; ++i) {
                        unit.setOption(i, inputStream.readByte());
                    }
                    e = world.a(inputStream.readInt());
                    if (e instanceof qx && !((qx)e).cd.d) {
                        qw inv = ((qx)e).bJ;
                        byte required = unit.getCost();
                        MBCommander.PROXY.scanForGold(inv, required);
                    }
                    unit.setOwner(previous.getOwner());
                    world.d((lq)unit);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static di generateParticleEffectPacket(byte i, lq centerEntity) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(5);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(i);
            outputStream.writeInt(centerEntity.k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new di(particlePacket, bos.toByteArray());
    }

    public static di generateSpawnPacket(EntityMBUnit unit, int x, int y, int z, qx player) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(31);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeInt(unit.k);
            outputStream.writeInt(x);
            outputStream.writeInt(y);
            outputStream.writeInt(z);
            outputStream.writeByte((byte)(player.z * 256.0f / 360.0f));
            outputStream.writeByte((byte)(unit.A * 256.0f / 360.0f));
            outputStream.writeByte((byte)unit.getTeam().ordinal());
            outputStream.writeByte((byte)unit.getUnitType().ordinal());
            for (int i = 0; i < 6; ++i) {
                outputStream.writeByte(unit.getOption(i));
            }
            outputStream.writeInt(player.k);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new di(spawnPacket, bos.toByteArray());
    }

    public static EntityMBUnit readUnitFromPacket(di p, yc world, qx player) {
        if (p.a.equals(spawnPacket)) {
            DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(p.c));
            try {
                int id = inputStream.readInt();
                int x = inputStream.readInt();
                int y = inputStream.readInt();
                int z = inputStream.readInt();
                byte pitch = inputStream.readByte();
                byte yaw = inputStream.readByte();
                world.a(x, y, z, null);
                world.a(x, y + 1, z, null);
                world.e(x, y, z, 0);
                world.e(x, y + 1, z, 0);
                EntityMBUnit unit = EntityMBUnit.generateUnit(world, EnumTeam.values()[inputStream.readByte()], EnumUnits.values()[inputStream.readByte()]);
                unit.b((double)x + 0.5, y, (double)z + 0.5, player.z, player.A);
                unit.setOrder(EnumOrder.StandGuard, new int[]{x, y, z}, "");
                for (int i = 0; i < 6; ++i) {
                    unit.setOption(i, inputStream.readByte());
                }
                lq e = world.a(inputStream.readInt());
                if (e instanceof qx && !((qx)e).cd.d) {
                    qw inv = ((qx)e).bJ;
                    byte required = unit.getCost();
                    MBCommander.PROXY.scanForGold(inv, required);
                }
                unit.setOwner(player.bR);
                return unit;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

