/*
 * Decompiled with CFR 0.152.
 */
package mab.client.commander.lang;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import net.minecraft.client.Minecraft;

public class LanguageHelper {
    public static void loadAllLanguages() {
        LanguageHelper.loadDefault();
        File folder = LanguageHelper.getOrGenerateLangFolder();
        LanguageHelper.readAllLanguages(folder);
    }

    private static void loadDefault() {
        System.out.println("Mine & Blade: Loading Default Language");
        String line = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(LanguageHelper.class.getResourceAsStream("en_US.lang")));
            while ((line = reader.readLine()) != null) {
                String[] split = line.split("=");
                if (split.length != 2) continue;
                LanguageRegistry.instance().addStringLocalization(split[0], "en_US", split[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readAllLanguages(File folder) {
        BufferedReader reader = null;
        if (folder.exists()) {
            for (File langFile : folder.listFiles()) {
                if (!langFile.getName().endsWith(".lang")) continue;
                try {
                    reader = new BufferedReader(new FileReader(langFile));
                    String l = langFile.getName().substring(0, langFile.getName().length() - 5);
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        String[] split = line.split("=");
                        if (split.length != 2) continue;
                        LanguageRegistry.instance().addStringLocalization(split[0], l, split[1]);
                    }
                    System.out.println("Mine & Blade: Loaded Language " + l);
                }
                catch (Exception e) {
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
    }

    private static File getOrGenerateLangFolder() {
        FMLClientHandler.instance().getClient();
        File dir = Minecraft.b();
        File MBLang = new File(dir.getAbsolutePath() + File.separator + "lang" + File.separator + "Mine & Blade");
        if (!MBLang.exists()) {
            System.out.println("Mine & Blade: Generating Language Folder");
            MBLang.mkdirs();
        }
        return MBLang;
    }
}

