/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public final class ForgePacketWrapper {
    public static dk createPacket(String channel, int packetID, Object[] input) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.write(packetID);
            if (input != null) {
                for (Object obj : input) {
                    ForgePacketWrapper.writeObjectToStream(obj, data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        dk packet = new dk();
        packet.a = channel;
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        return packet;
    }

    public static Object[] readPacketData(DataInputStream data, Class[] packetDataTypes) {
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            for (Class curClass : packetDataTypes) {
                result.add(ForgePacketWrapper.readObjectFromStream(data, curClass));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result.toArray();
    }

    private static void writeObjectToStream(Object obj, DataOutputStream data) throws IOException {
        Class<?> objClass = obj.getClass();
        if (objClass.equals(Boolean.class)) {
            data.writeBoolean((Boolean)obj);
        } else if (objClass.equals(Byte.class)) {
            data.writeByte(((Byte)obj).byteValue());
        } else if (objClass.equals(Integer.class)) {
            data.writeInt((Integer)obj);
        } else if (objClass.equals(String.class)) {
            data.writeUTF((String)obj);
        } else if (objClass.equals(Double.class)) {
            data.writeDouble((Double)obj);
        } else if (objClass.equals(Float.class)) {
            data.writeFloat(((Float)obj).floatValue());
        } else if (objClass.equals(Long.class)) {
            data.writeLong((Long)obj);
        } else if (objClass.equals(Short.class)) {
            data.writeShort(((Short)obj).shortValue());
        }
    }

    private static Object readObjectFromStream(DataInputStream data, Class curClass) throws IOException {
        if (curClass.equals(Boolean.class)) {
            return data.readBoolean();
        }
        if (curClass.equals(Byte.class)) {
            return data.readByte();
        }
        if (curClass.equals(Integer.class)) {
            return data.readInt();
        }
        if (curClass.equals(String.class)) {
            return data.readUTF();
        }
        if (curClass.equals(Double.class)) {
            return data.readDouble();
        }
        if (curClass.equals(Float.class)) {
            return Float.valueOf(data.readFloat());
        }
        if (curClass.equals(Long.class)) {
            return data.readLong();
        }
        if (curClass.equals(Short.class)) {
            return data.readShort();
        }
        return null;
    }

    public static int readPacketID(DataInputStream data) {
        int result = -1;
        try {
            result = data.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

