package mods.nandonalt.coralmod.client;

import java.util.EnumSet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;

import org.lwjgl.input.Keyboard;

import cpw.mods.fml.client.registry.KeyBindingRegistry.KeyHandler;
import cpw.mods.fml.common.TickType;

public class CoralKeyHandler extends KeyHandler {

	public static final KeyBinding binding = new KeyBinding("Coral Reef GUI", Keyboard.KEY_C);

	public CoralKeyHandler() {
		super(new KeyBinding[]{binding}, new boolean[]{false});
	}

	@Override
	public String getLabel() {
		return "CoralKeyHandler";
	}

	@Override
	public void keyDown(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd, boolean isRepeat) {
		Minecraft game = Minecraft.getMinecraft();
		if (game.currentScreen == null) {
			game.displayGuiScreen(new GuiCoralReef());
		}
	}

	@Override
	public void keyUp(EnumSet<TickType> types, KeyBinding kb, boolean tickEnd) {}

	@Override
	public EnumSet<TickType> ticks() {
		EnumSet<TickType> tickTypes = EnumSet.allOf(TickType.class);
		return tickTypes;
	}

}