package mods.nandonalt.coralmod;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class BlockCoral2 extends Block {

	private final int type;

	@SideOnly(Side.CLIENT)
	private Icon[] iconBuffer;

	public BlockCoral2(int blockID, int type) {
		super(blockID, Material.rock);
		setCreativeTab(CreativeTabs.tabDecorations);
		this.type = type;
	}

	@Override
	public boolean canPlaceBlockAt(World world, int x, int y, int z) {
		int currentBlockId = world.getBlockId(x, y, z);
		if(currentBlockId > 0 && currentBlockId < Block.blocksList.length) {
			Block currentBlock = Block.blocksList[currentBlockId];
			if(currentBlock != null) {
				String blockName = currentBlock.getUnlocalizedName();
				if(blockName.startsWith("tile.Coral") && blockName.length() == 11) {
					return false;
				}
			}
		}
		return super.canPlaceBlockAt(world, x, y, z);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerIcons(IconRegister iconRegister) {
		iconBuffer = new Icon[2];
		iconBuffer[0] = iconRegister.registerIcon("coralmod:reef1");
		iconBuffer[1] = iconRegister.registerIcon("coralmod:reef2");
	}

	@SideOnly(Side.CLIENT)
	@Override
	public Icon getIcon(int side, int metadata) {
		final Icon sprite;
		if(type < 0 || type > iconBuffer.length) {
			sprite = iconBuffer[0];
		} else {
			sprite = iconBuffer[type];
		}

		return sprite;
	}

}
