/*
 * Decompiled with CFR 0.152.
 */
package fyber.redstonepastemod;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import fyber.redstonepastemod.BlockRedstonePaste;
import fyber.redstonepastemod.CommonProxy;
import fyber.redstonepastemod.ItemRedstonePaste;
import fyber.redstonepastemod.ItemStickyComparator;
import fyber.redstonepastemod.ItemStickyRepeater;
import fyber.redstonepastemod.MaterialPaste;
import fyber.redstonepastemod.TileEntityRedstonePaste;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="RedstonePasteMod", name="Redstone Paste", version="1.6")
public class RedstonePasteMod {
    @Mod.Instance(value="RedstonePasteMod")
    public static RedstonePasteMod instance;
    @SidedProxy(clientSide="fyber.redstonepastemod.client.ClientProxy", serverSide="fyber.redstonepastemod.CommonProxy")
    public static CommonProxy proxy;
    private int blockId;
    private int repeaterId;
    private int comparatorId;
    private int pasteRecipeType = 0;
    private int pasteRecipeResult = 4;
    public String pasteColorOn;
    public String pasteColorMid;
    public String pasteColorOff;
    public BlockRedstonePaste blockRedstonePaste;
    public MaterialPaste materialPaste;
    public ItemStickyRepeater itemStickyRepeater;
    public ItemStickyComparator itemStickyComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            this.pasteRecipeType = cfg.get("General", "pasteRecipeType", 0, "Redstone Paste recipe (default: 0)\n0 = shapeless slimeball and dust\n1 = slimeball surrounded by dust").getInt(0);
            this.pasteRecipeResult = cfg.get("General", "pasteRecipeResult", 4, "Number of paste obtained from crafting recipe (default: 4)").getInt(4);
            this.pasteColorOn = cfg.get("Color", "pasteColorOn", "#FF5200", "Color of fully-powered paste (default: #FF5200)").getString();
            this.pasteColorMid = cfg.get("Color", "pasteColorMid", "#E66400", "Color of half-powered paste (default: #E66400)").getString();
            this.pasteColorOff = cfg.get("Color", "pasteColorOff", "#80B400", "Color of unpowered paste (default: #80B400)").getString();
        }
        catch (Exception e) {
            FMLLog.severe((String)"RedstonePasteMod has a problem loading it's configuration", (Object[])new Object[0]);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        if (this.pasteRecipeResult < 1) {
            this.pasteRecipeResult = 1;
        }
        if (this.pasteRecipeResult > 64) {
            this.pasteRecipeResult = 64;
        }
        this.materialPaste = new MaterialPaste(MapColor.field_151660_b);
        this.blockRedstonePaste = new BlockRedstonePaste(this.blockId, this.materialPaste);
        this.itemStickyRepeater = new ItemStickyRepeater(this.repeaterId);
        this.itemStickyComparator = new ItemStickyComparator(this.comparatorId);
        GameRegistry.registerBlock((Block)this.blockRedstonePaste, ItemRedstonePaste.class, (String)"redstonePaste");
        GameRegistry.registerItem((Item)this.itemStickyRepeater, (String)"stickyRepeater");
        GameRegistry.registerItem((Item)this.itemStickyComparator, (String)"stickyComparator");
        GameRegistry.registerTileEntity(TileEntityRedstonePaste.class, (String)"redstonePasteTE");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) throws IOException {
        proxy.registerRenderers();
        if (this.pasteRecipeType == 1) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockRedstonePaste, this.pasteRecipeResult), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151137_ax), Character.valueOf('y'), new ItemStack(Items.field_151123_aH)});
        } else if (this.pasteRecipeType == 2) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)this.blockRedstonePaste, this.pasteRecipeResult), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('y'), new ItemStack(Items.field_151137_ax), Character.valueOf('x'), new ItemStack(Items.field_151123_aH)});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)this.blockRedstonePaste, this.pasteRecipeResult), (Object[])new Object[]{new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151123_aH)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemStickyRepeater, 1), (Object[])new Object[]{new ItemStack(Items.field_151107_aW), new ItemStack(Items.field_151123_aH)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)this.itemStickyComparator, 1), (Object[])new Object[]{new ItemStack(Items.field_151132_bS), new ItemStack(Items.field_151123_aH)});
        proxy.initHighlighter();
        proxy.initPasteColors();
    }
}

