/*
 * Decompiled with CFR 0.152.
 */
package assets.levelup;

import assets.levelup.LevelUp;
import assets.levelup.PlayerEventHandler;
import assets.levelup.PlayerExtendedProperties;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class LevelUpHUD
extends Gui {
    private Minecraft mc;
    private float val = 0.7f;
    private float valIncr = 0.005f;
    private static final int minLevel = 3;
    private static final int minXp = 20 - PlayerEventHandler.xpPerLevel;

    public LevelUpHUD(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void addToText(List<String> left) {
        byte playerClass = PlayerExtendedProperties.getPlayerClass((EntityPlayer)this.mc.field_71439_g);
        if (playerClass != 0) {
            int skillXP;
            if (!LevelUp.renderExpBar && (skillXP = PlayerExtendedProperties.getSkillFromIndex((EntityPlayer)this.mc.field_71439_g, "XP")) > 0) {
                left.add(StatCollector.func_74838_a((String)"hud.skill.text1") + skillXP);
            }
            left.add(StatCollector.func_74838_a((String)"hud.skill.text2") + StatCollector.func_74838_a((String)("class" + playerClass + ".name")));
        } else if (!(this.mc.field_71439_g.field_71068_ca <= 3 && PlayerExtendedProperties.getSkillPoints((EntityPlayer)this.mc.field_71439_g) <= minXp || LevelUp.renderExpBar)) {
            left.add(StatCollector.func_74838_a((String)"hud.skill.select"));
        }
    }

    @SubscribeEvent
    public void renderLvlUpHUD(RenderGameOverlayEvent.Pre event) {
        if (this.mc.field_71439_g != null) {
            if (LevelUp.renderTopLeft && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
                this.addToText(((RenderGameOverlayEvent.Text)event).left);
            }
            if (LevelUp.renderExpBar && event.type == RenderGameOverlayEvent.ElementType.EXPERIENCE) {
                this.addToExpBar(event.resolution);
            }
        }
    }

    private void addToExpBar(ScaledResolution res) {
        this.val += this.valIncr;
        if (this.val >= 1.0f || this.val <= 0.4f) {
            this.valIncr *= -1.0f;
        }
        if (this.val > 1.0f) {
            this.val = 1.0f;
        }
        if (this.val < 0.4f) {
            this.val = 0.4f;
        }
        int col = Color.HSBtoRGB(0.2929688f, 1.0f, this.val) & 0xFFFFFF;
        byte playerClass = PlayerExtendedProperties.getPlayerClass((EntityPlayer)this.mc.field_71439_g);
        String text = null;
        if (playerClass != 0) {
            int skillXP = PlayerExtendedProperties.getSkillFromIndex((EntityPlayer)this.mc.field_71439_g, "XP");
            if (skillXP > 0) {
                text = StatCollector.func_74838_a((String)"hud.skill.text1") + skillXP;
            }
        } else if (this.mc.field_71439_g.field_71068_ca > 3 || PlayerExtendedProperties.getSkillPoints((EntityPlayer)this.mc.field_71439_g) > minXp) {
            text = StatCollector.func_74838_a((String)"hud.skill.select");
        }
        int x = (res.func_78326_a() - this.mc.field_71466_p.func_78256_a(text)) / 2;
        int y = res.func_78328_b() - 29;
        if (text != null) {
            this.mc.field_71466_p.func_78276_b(text, x, y, col);
        }
        this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
    }
}

