/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.mobsplicecore.asm;

import cpw.mods.fml.common.FMLLog;
import ganymedes01.mobsplicecore.asm.MSFMLLoadingPlugin;
import java.io.File;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.launchwrapper.IClassTransformer;

public class MSClassTransformer
implements IClassTransformer {
    private static final Logger logger = Logger.getLogger("MobSpliceCore");

    static {
        logger.setParent(FMLLog.getLogger());
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (MSFMLLoadingPlugin.file == null) {
            return bytes;
        }
        if (MSFMLLoadingPlugin.classesToPatch.contains(name)) {
            bytes = this.patchClassInJar(name, bytes, MSFMLLoadingPlugin.file);
        }
        return bytes;
    }

    public byte[] patchClassInJar(String name, byte[] bytes, File location) {
        try {
            ZipFile zip = new ZipFile(location);
            ZipEntry entry = zip.getEntry(String.valueOf(name.replace('.', '/')) + ".class");
            if (entry == null) {
                logger.log(Level.SEVERE, String.valueOf(name) + " not found in " + location.getName());
            } else {
                InputStream zin = zip.getInputStream(entry);
                bytes = new byte[(int)entry.getSize()];
                zin.read(bytes);
                zin.close();
                logger.log(Level.FINE, "Class " + name + " patched.");
            }
            zip.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error overriding " + name + " from " + location.getName(), e);
        }
        return bytes;
    }
}

