/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import noppes.mpm.ModelData;
import noppes.mpm.MorePlayerModels;
import noppes.mpm.PacketHandlerServer;
import noppes.mpm.PlayerDataController;
import noppes.mpm.client.ChatMessages;
import noppes.mpm.constants.EnumPackets;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ByteBufInputStream buf = new ByteBufInputStream(event.packet.payload());
        try {
            this.handlePacket(buf, (EntityPlayer)player, EnumPackets.values()[buf.readInt()]);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void handlePacket(ByteBufInputStream dis, EntityPlayer player, EnumPackets type) throws IOException {
        if (type == EnumPackets.PING) {
            MorePlayerModels.HasServerSide = true;
        } else if (type == EnumPackets.SEND_PLAYER_DATA) {
            String username = dis.readUTF();
            ModelData data = PlayerDataController.instance.getPlayerData(username);
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            data.readFromNBT(compound);
            PlayerDataController.instance.savePlayerData(username, data);
        } else if (type == EnumPackets.CHAT_EVENT) {
            String username = dis.readUTF();
            String message = dis.readUTF();
            ChatMessages.getChatMessages(username).addMessage(message);
        } else if (type == EnumPackets.BACK_ITEM_REMOVE) {
            String username = dis.readUTF();
            ModelData data = PlayerDataController.instance.getPlayerData(username);
            data.backItem = null;
        } else if (type == EnumPackets.BACK_ITEM_UPDATE) {
            String username = dis.readUTF();
            NBTTagCompound compound = CompressedStreamTools.func_74794_a((DataInput)dis);
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)compound);
            ModelData data = PlayerDataController.instance.getPlayerData(username);
            data.backItem = item;
        } else if (type == EnumPackets.PARTICLE) {
            int animation = dis.readInt();
            if (animation == 0) {
                String username = dis.readUTF();
                ModelData data = PlayerDataController.instance.getPlayerData(username);
                data.inLove = 40;
            } else if (animation == 1) {
                player.field_70170_p.func_72869_a("note", dis.readDouble(), dis.readDouble(), dis.readDouble(), dis.readDouble(), 0.0, 0.0);
            } else if (animation == 2) {
                String username = dis.readUTF();
                ModelData data = PlayerDataController.instance.getPlayerData(username);
                for (int i = 0; i < 5; ++i) {
                    double d0 = player.func_70681_au().nextGaussian() * 0.02;
                    double d1 = player.func_70681_au().nextGaussian() * 0.02;
                    double d2 = player.func_70681_au().nextGaussian() * 0.02;
                    double x = player.field_70165_t + (double)((player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 2.0f);
                    double z = player.field_70161_v + (double)((player.func_70681_au().nextFloat() - 0.5f) * player.field_70130_N * 2.0f);
                    player.field_70170_p.func_72869_a("angryVillager", x, player.field_70163_u + (double)0.8f + (double)(player.func_70681_au().nextFloat() * player.field_70131_O / 2.0f) - player.func_70033_W() - (double)data.getBodyY(), z, d0, d1, d2);
                }
            }
        } else if (type == EnumPackets.ANIMATION) {
            String username = dis.readUTF();
            ModelData data = PlayerDataController.instance.getPlayerData(username);
            data.setAnimation(dis.readInt());
            EntityPlayer p = player.field_70170_p.func_72924_a(username);
            if (p != null) {
                data.animationStart = p.field_70173_aa;
            }
        }
    }
}

