/*
 * Decompiled with CFR 0.152.
 */
package noppes.mpm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import noppes.mpm.ModelData;

public class PlayerDataController {
    public HashMap<String, ModelData> players = new HashMap();
    private File dir;
    public static PlayerDataController instance;

    public PlayerDataController(File dir) {
        instance = this;
        this.dir = new File(dir, "playerdata");
        if (!this.dir.exists()) {
            this.dir.mkdir();
        }
    }

    public ModelData getPlayerData(String username) {
        String original = username;
        ModelData data = this.players.get(username = username.toLowerCase());
        if (data == null) {
            NBTTagCompound compound = this.loadPlayerData(username);
            data = new ModelData();
            this.players.put(username, data);
            if (compound != null) {
                data.readFromNBT(compound);
            }
        }
        data.username = original;
        return data;
    }

    private NBTTagCompound loadPlayerData(String player) {
        String filename = player;
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".dat";
        try {
            File file = new File(this.dir, filename);
            if (!file.exists()) {
                return null;
            }
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            try {
                File file = new File(this.dir, filename + "_old");
                if (!file.exists()) {
                    return null;
                }
                return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
            }
            catch (Exception e2) {
                System.err.println(e2.getMessage());
                return null;
            }
        }
    }

    public void savePlayerData(String player, ModelData data) {
        String filename = player.toLowerCase();
        if (filename.isEmpty()) {
            filename = "noplayername";
        }
        filename = filename + ".dat";
        try {
            File file = new File(this.dir, filename + "_new");
            File file1 = new File(this.dir, filename + "_old");
            File file2 = new File(this.dir, filename);
            CompressedStreamTools.func_74799_a((NBTTagCompound)data.writeToNBT(), (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

