/*
 * Decompiled with CFR 0.152.
 */
package glenn.gases;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import glenn.gases.BlockGasElectric;
import glenn.gases.BlockGasVoid;
import glenn.gases.CommonProxy;
import glenn.gases.DamageSourceLightning;
import glenn.gases.EntityGlowstoneShard;
import glenn.gases.EntitySmallLightning;
import glenn.gases.GasTypePoisonous;
import glenn.gases.ItemGasDetector;
import glenn.gases.ItemGlowstoneShard;
import glenn.gases.UpdateChecker;
import glenn.gases.WorldGeneratorGases;
import glenn.gases.client.SoundBus;
import glenn.gases.reaction.ReactionAcidVapour;
import glenn.gases.reaction.ReactionCorrosion;
import glenn.gases.reaction.ReactionGlowstoneShard;
import glenn.gasesframework.BlockGas;
import glenn.gasesframework.BlockGasPipe;
import glenn.gasesframework.BlockLantern;
import glenn.gasesframework.BlockLanternSpecial;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionIgnition;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="gases", name="Glenn's Gases", version="1.4.3", dependencies="required-after:gasesFramework; required-after:gasesCore")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class Gases {
    @Mod.Instance(value="gases")
    public static Gases instance;
    @SidedProxy(clientSide="glenn.gases.client.ClientProxy", serverSide="glenn.gases.CommonProxy")
    public static CommonProxy proxy;
    public static final String version = "1.4.3";
    private static Configuration config;
    public static int generateGreenGas;
    public static int generateRedGas;
    public static int generateNitrousGas;
    public static int generateElectricGas;
    public static int generateCorrosiveGas;
    public static int voidGasMaxHeight;
    public static float maxHardnessForCorrosion;
    public static boolean enableUpdateCheck;
    public static final na lightningDamageSource;
    public static yb glowstoneShard;
    public static yb gasDetector;
    public static yb gasSensitiveChip;
    public static BlockGas gasSteam;
    public static BlockGas gasRisingFlammable;
    public static BlockGas gasFallingExplosive;
    public static BlockGas gasVoid;
    public static BlockGas gasElectric;
    public static BlockGas gasCorrosive;
    public static BlockGas gasNitrous;
    public static BlockGas gasAcidVapour;
    public static BlockGas gasCoalDust;
    public static BlockGasPipe gasPipeSteam;
    public static BlockGasPipe gasPipeRisingFlammable;
    public static BlockGasPipe gasPipeFallingExplosive;
    public static BlockGasPipe gasPipeElectric;
    public static BlockGasPipe gasPipeCorrosive;
    public static BlockGasPipe gasPipeNitrous;
    public static BlockLantern lanternTorch;
    public static BlockLantern lanternGlowstone;
    public static GasType gasTypeSteam;
    public static GasType gasTypeRisingFlammable;
    public static GasType gasTypeFallingExplosive;
    public static GasType gasTypeVoid;
    public static GasType gasTypeElectric;
    public static GasType gasTypeCorrosive;
    public static GasType gasTypeNitrous;
    public static GasType gasTypeAcidVapour;
    public static GasType gasTypeCoalDust;

    private void initBlocksAndItems() {
        glowstoneShard = new ItemGlowstoneShard(Gases.b("glowstoneShardID", 401)).b("glowstoneShard").a(GasesFramework.creativeTab).d("gases:glowstone_shard");
        GameRegistry.registerItem((yb)glowstoneShard, (String)"glowstoneShard");
        gasDetector = new ItemGasDetector(Gases.b("gasDetectorID", 403)).b("gasDetector").a(GasesFramework.creativeTab).d("gases:detector");
        GameRegistry.registerItem((yb)gasDetector, (String)"gasDetector");
        gasSensitiveChip = new yb(Gases.b("gasSensitiveChipID", 404)).b("gasSensitiveChip").a(GasesFramework.creativeTab).d("gases:chip");
        GameRegistry.registerItem((yb)gasSensitiveChip, (String)"gasSensitiveChip");
        gasSteam = (BlockGas)new BlockGas(Gases.a("gasSteamID", 501)).c("gasSteam").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasSteam, (String)"gasSteam");
        gasRisingFlammable = (BlockGas)new BlockGas(Gases.a("gasRisingFlammableID", 502)).c("gasRisingFlammable").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasRisingFlammable, (String)"gasRisingFlammable");
        gasFallingExplosive = (BlockGas)new BlockGas(Gases.a("gasFallingExplosiveID", 503)).c("gasFallingExplosive").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasFallingExplosive, (String)"gasFallingExplosive");
        gasVoid = (BlockGas)new BlockGasVoid(Gases.a("gasVoidID", 504)).c("gasVoid").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasVoid, (String)"gasVoid");
        gasElectric = (BlockGas)new BlockGasElectric(Gases.a("gasElectricID", 505)).c("gasElectric").a(GasesFramework.creativeTab).d("gases:gas_special");
        GameRegistry.registerBlock((aqw)gasElectric, (String)"gasElectric");
        gasCorrosive = (BlockGas)new BlockGas(Gases.a("gasCorrosiveID", 506)).c("gasCorrosive").a(GasesFramework.creativeTab).d("gases:gas_special");
        GameRegistry.registerBlock((aqw)gasCorrosive, (String)"gasCorrosive");
        gasNitrous = (BlockGas)new BlockGas(Gases.a("gasNitrousID", 506)).c("gasNitrous").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasNitrous, (String)"gasNitrous");
        gasAcidVapour = (BlockGas)new BlockGas(Gases.a("gasAcidVapourID", 507)).c("gasAcidVapour").d("gases:gas_special");
        GameRegistry.registerBlock((aqw)gasAcidVapour, (String)"gasAcidVapour");
        gasCoalDust = (BlockGas)new BlockGas(Gases.a("gasCoalDustID", 508)).c("gasCoalDust").a(GasesFramework.creativeTab);
        GameRegistry.registerBlock((aqw)gasCoalDust, (String)"gasCoalDust");
        gasPipeSteam = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeSteamID", 527)).c("gasPipeSteam");
        GameRegistry.registerBlock((aqw)gasPipeSteam, (String)"gasPipeSteam");
        gasPipeRisingFlammable = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeRisingFlammableID", 528)).c("gasPipeRisingFlammable");
        GameRegistry.registerBlock((aqw)gasPipeRisingFlammable, (String)"gasPipeRisingFlammable");
        gasPipeFallingExplosive = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeFallingExplosiveID", 529)).c("gasPipeFallingExplosive");
        GameRegistry.registerBlock((aqw)gasPipeFallingExplosive, (String)"gasPipeFallingExplosive");
        gasPipeElectric = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeElectricID", 531)).c("gasPipeElectric");
        GameRegistry.registerBlock((aqw)gasPipeElectric, (String)"gasPipeElectric");
        gasPipeCorrosive = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeCorrosiveID", 532)).c("gasPipeCorrosive");
        GameRegistry.registerBlock((aqw)gasPipeCorrosive, (String)"gasPipeCorrosive");
        gasPipeNitrous = (BlockGasPipe)new BlockGasPipe(Gases.a("gasPipeNitrousID", 532)).c("gasPipeNitrous");
        GameRegistry.registerBlock((aqw)gasPipeNitrous, (String)"gasPipeNitrous");
        lanternTorch = (BlockLantern)new BlockLanternSpecial(Gases.a("lanternTorchID", 551), 0, new yd(aqw.av), new yd(aqw.av), null).a(0.625f).c("lanternTorch").d("gases:lantern_torch");
        GameRegistry.registerBlock((aqw)lanternTorch, (String)"lanternTorch");
        lanternGlowstone = (BlockLantern)new BlockLanternSpecial(Gases.a("lanternGlowstoneID", 554), 0, new yd(yb.aV), new yd(yb.aV), null).a(1.0f).c("lanternGlowstone").d("gases:lantern_glowstone");
        GameRegistry.registerBlock((aqw)lanternGlowstone, (String)"lanternGlowstone");
        gasTypeSteam = new GasType(gasSteam, gasPipeSteam, 2, "Steam", 0xFFFFFF, 0, -8, Combustibility.NONE).setDamage(2.0f).setEvaporationRate(2);
        gasTypeRisingFlammable = new GasType(gasRisingFlammable, gasPipeRisingFlammable, 3, "Green gas", 0x6F7F6F, 1, -12, Combustibility.FLAMMABLE).setEffectRates(2, 2, 0);
        gasTypeFallingExplosive = new GasType(gasFallingExplosive, gasPipeFallingExplosive, 4, "Red gas", 0x7F4F4F, 3, 4, Combustibility.EXPLOSIVE).setEffectRates(1, 2, 0);
        gasTypeVoid = new GasType(gasVoid, 5, "Void gas", 0x1F1F1F, 4, 8, Combustibility.NONE).setEffectRates(20, 4, 0).setDamage(1.0f);
        gasTypeElectric = new GasType(gasElectric, gasPipeElectric, 6, "Electric gas", 0x1F7F7F, 0, 0, Combustibility.NONE).setEffectRates(4, 2, 0);
        gasTypeCorrosive = new GasType(gasCorrosive, gasPipeCorrosive, 7, "Corrosive gas", 0x1F1FDF, 0, 0, Combustibility.NONE).setEffectRates(4, 2, 0).setDamage(0.5f);
        gasTypeNitrous = new GasTypePoisonous(gasNitrous, gasPipeNitrous, 8, "Nitrous gas", 7290671, 3, 4, Combustibility.NONE).setEffectRates(1, 4, 0);
        gasTypeAcidVapour = new GasType(gasAcidVapour, 9, "Acidic vapour", 5210047, 0, -20, Combustibility.NONE).setEffectRates(20, 1, 0).setDamage(2.0f).setEvaporationRate(2);
        gasTypeCoalDust = new GasType(gasCoalDust, 10, "Coal dust", 0x2F2F2F, 0, 0, Combustibility.HIGHLY_EXPLOSIVE).setEffectRates(1, 6, 0).setEvaporationRate(5);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.initBlocksAndItems();
        generateGreenGas = config.get("world", "generateGreenGasAmount", true).getInt(8);
        generateRedGas = config.get("world", "generateRedGasAmount", true).getInt(4);
        generateNitrousGas = config.get("world", "generateNitrousGasAmount", true).getInt(4);
        generateElectricGas = config.get("world", "generateElectricGasAmount", true).getInt(4);
        generateCorrosiveGas = config.get("world", "generateCorrosiveGasAmount", true).getInt(4);
        voidGasMaxHeight = config.get("gases", "voidGasMaxHeight", true).getInt(64);
        maxHardnessForCorrosion = Float.parseFloat(config.get("gases", "maxHardnessForCorrosion", 2.0).getString());
        enableUpdateCheck = config.get("other", "enableUpdateCheck", true).getBoolean(true);
        config.save();
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)new SoundBus());
        }
        MinecraftForge.EVENT_BUS.register((Object)new UpdateChecker());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGeneratorGases());
        GameRegistry.addRecipe((yd)new yd(gasSensitiveChip), (Object[])new Object[]{"GRG", "RDR", "GRG", Character.valueOf('G'), yb.r, Character.valueOf('R'), yb.aE, Character.valueOf('D'), yb.p});
        for (int i = 0; i < GasType.gasTypes.length; ++i) {
            GasType type;
            if (!(i == 0 | ((type = GasType.gasTypes[i]) != null && type.isIndustrial()))) continue;
            GameRegistry.addRecipe((yd)new yd(gasDetector, 1, i), (Object[])new Object[]{" I ", "ICS", " I ", Character.valueOf('S'), new yd(GasesFramework.gasSamplerIncluder, 1, i), Character.valueOf('I'), new yd(yb.q), Character.valueOf('C'), new yd(gasSensitiveChip)});
        }
        GasesFramework.addSpecialFurnaceRecipe((yd)new yd(yb.o, 64), (yd)new yd(yb.p), (int)25600);
        GasesFramework.registerIgnitionBlock((int)aqw.av.cF);
        GasesFramework.registerIgnitionBlock((int)aqw.aw.cF);
        GasesFramework.registerReaction((Reaction)new ReactionIgnition());
        GasesFramework.registerReaction((Reaction)new ReactionGlowstoneShard((aqw)gasElectric, (aqw)gasCorrosive));
        GasesFramework.registerReaction((Reaction)new ReactionCorrosion(gasCorrosive));
        GasesFramework.registerReaction((Reaction)new ReactionAcidVapour(11, (aqw)gasNitrous, aqw.G));
        GasesFramework.registerReaction((Reaction)new ReactionAcidVapour(12, (aqw)gasNitrous, (aqw)aqw.F));
        LanguageRegistry.addName((Object)gasSteam, (String)"Steam");
        LanguageRegistry.addName((Object)gasRisingFlammable, (String)"Green Gas");
        LanguageRegistry.addName((Object)gasFallingExplosive, (String)"Red Gas");
        LanguageRegistry.addName((Object)gasVoid, (String)"Void Gas");
        LanguageRegistry.addName((Object)gasElectric, (String)"Electric Gas");
        LanguageRegistry.addName((Object)gasCorrosive, (String)"Corrosive Gas");
        LanguageRegistry.addName((Object)gasNitrous, (String)"Nitrous Gas");
        LanguageRegistry.addName((Object)gasAcidVapour, (String)"Acidic Vapour");
        LanguageRegistry.addName((Object)gasCoalDust, (String)"Coal Dust");
        LanguageRegistry.addName((Object)lanternTorch, (String)"Lantern with Torch");
        LanguageRegistry.addName((Object)lanternGlowstone, (String)"Lantern with Glowstone");
        LanguageRegistry.addName((Object)glowstoneShard, (String)"Glowstone Shard");
        LanguageRegistry.addName((Object)gasSensitiveChip, (String)"Gas Sensitive Chip");
        EntityRegistry.registerGlobalEntityID(EntitySmallLightning.class, (String)"smallLightning", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntitySmallLightning.class, (String)"smallLightning", (int)127, (Object)this, (int)20, (int)1, (boolean)false);
        EntityRegistry.registerGlobalEntityID(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityGlowstoneShard.class, (String)"glowstoneShard", (int)126, (Object)this, (int)20, (int)1, (boolean)false);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static int a(String name, int def) {
        return config.getBlock(name, def).getInt();
    }

    private static int b(String name, int def) {
        return config.getItem(name, def).getInt();
    }

    static {
        GasesFramework.ENCOURAGE_MECHANICAL_ITEMS();
        GasesFramework.ENCOURAGE_LANTERNS();
        lightningDamageSource = new DamageSourceLightning("lightning");
    }
}

