/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.util;

public class PipeBranch {
    private static final int[] xDirection = new int[]{0, 0, 1, -1, 0, 0};
    private static final int[] yDirection = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] zDirection = new int[]{0, 0, 0, 0, 1, -1};
    public byte x;
    public byte y;
    public byte z;
    private byte[] direction;
    public byte length;

    public PipeBranch(byte x, byte y, byte z, byte direction) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = new byte[16];
        this.direction[0] = direction;
        this.length = 1;
    }

    private PipeBranch(byte x, byte y, byte z, byte[] direction, byte length) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
        this.length = length;
    }

    public PipeBranch(int x, int y, int z, int direction) {
        this((byte)x, (byte)y, (byte)z, (byte)direction);
    }

    public void addDirection(byte direction) {
        byte by = this.length;
        this.length = (byte)(by + 1);
        this.direction[by] = direction;
    }

    public void removeDirection() {
        byte by = this.length;
        this.length = (byte)(by - 1);
        if (by < 16) {
            this.direction[this.length + 1] = 0;
        }
    }

    public PipeBranch branch(int direction) {
        return this.branch((byte)direction);
    }

    public PipeBranch branch(byte direction) {
        PipeBranch pipeBranch = this.clone();
        pipeBranch.x = (byte)(pipeBranch.x + xDirection[direction]);
        pipeBranch.y = (byte)(pipeBranch.y + yDirection[direction]);
        pipeBranch.z = (byte)(pipeBranch.z + zDirection[direction]);
        pipeBranch.addDirection(direction);
        return pipeBranch;
    }

    public PipeBranch unBranch() {
        PipeBranch pipeBranch = this.clone();
        byte direction = this.getDirection();
        pipeBranch.x = (byte)(pipeBranch.x - xDirection[direction]);
        pipeBranch.y = (byte)(pipeBranch.y - yDirection[direction]);
        pipeBranch.z = (byte)(pipeBranch.z - zDirection[direction]);
        pipeBranch.removeDirection();
        return pipeBranch;
    }

    public PipeBranch clone() {
        PipeBranch pipeBranch = new PipeBranch(this.x, this.y, this.z, (byte[])this.direction.clone(), this.length);
        return pipeBranch;
    }

    public byte getDirection() {
        return this.direction[this.length - 1];
    }

    public int getReverseDirection() {
        byte d = this.getDirection();
        if (d >= 0 & d < 6) {
            return d / 2 * 2 + 1 - d % 2;
        }
        return -1;
    }

    public boolean holds(int x, int y, int z) {
        int i = this.length;
        int x1 = this.x;
        int y1 = this.y;
        int z1 = this.z;
        do {
            if (x == x1 && y == y1 && z == z1) {
                return true;
            }
            byte direction = this.direction[i - 1];
            x1 -= xDirection[direction];
            y1 -= yDirection[direction];
            z1 -= zDirection[direction];
        } while (--i > 0);
        return false;
    }
}

