/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework.reaction;

import glenn.gasesframework.BlockGas;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.reaction.Reaction;
import java.util.Random;

public class ReactionIgnition
extends Reaction {
    public ReactionIgnition() {
        super(10);
    }

    @Override
    public int getDelay(abv world, int block1X, int block1Y, int block1Z, int block2X, int block2Y, int block2Z) {
        int block1ID = world.a(block1X, block1Y, block1Z);
        int block2ID = world.a(block2X, block2Y, block2Z);
        if (GasesFramework.isIgnitionBlock(block2ID)) {
            if (aqw.s[block1ID] instanceof BlockGas && aqw.s[block1ID] != GasesFramework.gasFire) {
                return ((BlockGas)aqw.s[block1ID]).type.combustibility.fireSpreadRate;
            }
        } else if (GasesFramework.isIgnitionBlock(block1ID) && aqw.s[block2ID] instanceof BlockGas && aqw.s[block1ID] != GasesFramework.gasFire) {
            return ((BlockGas)aqw.s[block2ID]).type.combustibility.fireSpreadRate;
        }
        return -1;
    }

    @Override
    public boolean isErroneous() {
        return false;
    }

    @Override
    public boolean is(int block1ID, int block2ID) {
        if (GasesFramework.isIgnitionBlock(block2ID)) {
            aqw block = aqw.s[block1ID];
            return block instanceof BlockGas && ((BlockGas)block).canCombustNormally();
        }
        if (GasesFramework.isIgnitionBlock(block1ID)) {
            aqw block = aqw.s[block2ID];
            return block instanceof BlockGas && ((BlockGas)block).canCombustNormally();
        }
        return false;
    }

    @Override
    public boolean reactIfPossible(abv world, Random random, int block1X, int block1Y, int block1Z, int block2X, int block2Y, int block2Z) {
        int block1ID = world.a(block1X, block1Y, block1Z);
        int block2ID = world.a(block2X, block2Y, block2Z);
        if (GasesFramework.isIgnitionBlock(block2ID)) {
            if (aqw.s[block1ID] instanceof BlockGas && aqw.s[block1ID] != GasesFramework.gasFire) {
                int metadata = world.h(block1X, block1Y, block1Z);
                ((BlockGas)aqw.s[block1ID]).onFire(world, block1X, block1Y, block1Z, random);
                return true;
            }
        } else if (GasesFramework.isIgnitionBlock(block1ID) && aqw.s[block2ID] instanceof BlockGas && aqw.s[block1ID] != GasesFramework.gasFire) {
            ((BlockGas)aqw.s[block2ID]).onFire(world, block2X, block2Y, block2Z, random);
            return true;
        }
        return false;
    }

    @Override
    protected boolean reactBoth(abv world, Random random, int block1x, int block1y, int block1z, int block2x, int block2y, int block2z) {
        return false;
    }

    @Override
    protected boolean reactBlock1(abv world, Random random, int blockX, int blockY, int blockZ) {
        return false;
    }

    @Override
    protected boolean reactBlock2(abv world, Random random, int blockX, int blockY, int blockZ) {
        return false;
    }
}

