/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import glenn.gasesframework.BlockGasPump;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.IGasReceptor;
import glenn.gasesframework.IGasSource;
import glenn.gasesframework.util.DVec;
import java.util.Random;

public class TileEntityPump
extends asm {
    protected static final int[] xDirection = new int[]{0, 0, 1, -1, 0, 0};
    protected static final int[] yDirection = new int[]{1, -1, 0, 0, 0, 0};
    protected static final int[] zDirection = new int[]{0, 0, 0, 0, 1, -1};
    private int pumpTime = 25;
    private int failedPumpings;
    public boolean excludes = false;
    public GasType containedType;
    public GasType filterType;

    public void a(bx par1NBTTagCompound) {
        super.a(par1NBTTagCompound);
        this.pumpTime = par1NBTTagCompound.e("pumpTime");
        this.failedPumpings = par1NBTTagCompound.e("failedPumpings");
        this.excludes = par1NBTTagCompound.n("excludes");
        int i = par1NBTTagCompound.e("containedType");
        this.containedType = i == -1 ? null : GasType.gasTypes[i];
        i = par1NBTTagCompound.e("filterType");
        this.filterType = i == -1 ? null : GasType.gasTypes[i];
    }

    public void b(bx par1NBTTagCompound) {
        super.b(par1NBTTagCompound);
        par1NBTTagCompound.a("pumpTime", this.pumpTime);
        par1NBTTagCompound.a("failedPumpings", this.failedPumpings);
        par1NBTTagCompound.a("excludes", this.excludes);
        par1NBTTagCompound.a("containedType", this.containedType != null ? this.containedType.gasIndex : -1);
        par1NBTTagCompound.a("filterType", this.filterType != null ? this.filterType.gasIndex : -1);
    }

    public ex m() {
        bx nbtTag = new bx();
        this.b(nbtTag);
        return new gd(this.l, this.m, this.n, 1, nbtTag);
    }

    public void onDataPacket(cl net, gd packet) {
        this.a(packet.e);
    }

    public boolean acceptsType(GasType gasType) {
        if (this.filterType == null) {
            return true;
        }
        return this.filterType == gasType ^ this.excludes;
    }

    protected boolean extractFromSides() {
        int metadata = this.k.h(this.l, this.m, this.n);
        int[] indices = this.randomIndexArray(this.k.s);
        int i = 0;
        while (i < 6 & this.containedType == null) {
            int z1;
            int y1;
            int x1;
            aqw directionBlock;
            int index = indices[i];
            if (index != metadata && (directionBlock = aqw.s[this.k.a(x1 = this.l + xDirection[index], y1 = this.m + yDirection[index], z1 = this.n + zDirection[index])]) != null && IGasSource.class.isAssignableFrom(directionBlock.getClass())) {
                IGasSource gasSource = (IGasSource)directionBlock;
                if (this.acceptsType(gasSource.getGasTypeFromSide(this.k, x1, y1, z1, index))) {
                    this.containedType = gasSource.takeGasTypeFromSide(this.k, x1, y1, z1, index);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void handleFailedPumpings() {
        if (this.failedPumpings > 20 && this.k.s.nextInt(1000 / ((this.failedPumpings - 20) * (this.failedPumpings - 20)) + 1) == 0) {
            DVec velocity = DVec.randomNormalizedVec(this.k.s).scale(0.25);
            this.k.a("largesmoke", (double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, velocity.x, velocity.y, velocity.z);
        }
        if (this.failedPumpings > 60) {
            this.k.a(null, (double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5, 3.0f, true);
        }
    }

    public void h() {
        if (this.pumpTime-- <= 0) {
            if (!this.k.C(this.l, this.m, this.n)) {
                boolean canPumpAir;
                BlockGasPump block = (BlockGasPump)aqw.s[this.k.a(this.l, this.m, this.n)];
                int metadata = this.k.h(this.l, this.m, this.n);
                if (this.containedType == null & (canPumpAir = this.extractFromSides())) {
                    this.containedType = GasesFramework.gasTypeAir;
                }
                if (this.containedType != null) {
                    int x1 = this.l + xDirection[metadata];
                    int y1 = this.m + yDirection[metadata];
                    int z1 = this.n + zDirection[metadata];
                    int directionBlockID = this.k.a(x1, y1, z1);
                    aqw directionBlock = aqw.s[directionBlockID];
                    boolean success = false;
                    if (directionBlockID == 0) {
                        if (this.containedType.gasBlock != null) {
                            this.k.c(x1, y1, z1, this.containedType.gasBlock.cF);
                        }
                        success = true;
                    } else if (directionBlock != null && IGasReceptor.class.isAssignableFrom(directionBlock.getClass())) {
                        success = ((IGasReceptor)directionBlock).receiveGas(this.k, x1, y1, z1, metadata < 2 ? 1 - metadata : metadata, this.containedType);
                    }
                    if (success) {
                        this.containedType = null;
                        this.failedPumpings = 0;
                    } else {
                        ++this.failedPumpings;
                    }
                }
            } else {
                this.failedPumpings = 0;
            }
            this.pumpTime = 25;
        }
        this.handleFailedPumpings();
    }

    protected int[] randomIndexArray(Random random) {
        int[] array = new int[6];
        int i = 0;
        while (i < 6) {
            int index;
            while (array[index = random.nextInt(6)] != 0) {
            }
            array[index] = i++;
        }
        return array;
    }
}

