/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import glenn.gasesframework.BlockGas;
import glenn.gasesframework.BlockGasCollector;
import glenn.gasesframework.BlockGasFire;
import glenn.gasesframework.BlockGasFurnace;
import glenn.gasesframework.BlockGasPipe;
import glenn.gasesframework.BlockGasPump;
import glenn.gasesframework.BlockGasTank;
import glenn.gasesframework.BlockLantern;
import glenn.gasesframework.BlockLanternEmpty;
import glenn.gasesframework.BlockLanternSpecial;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.CommonProxy;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasTypeAir;
import glenn.gasesframework.GasTypeFire;
import glenn.gasesframework.GuiHandler;
import glenn.gasesframework.ItemGasBottle;
import glenn.gasesframework.ItemGasSampler;
import glenn.gasesframework.TileEntityGasCollector;
import glenn.gasesframework.TileEntityGasFurnace;
import glenn.gasesframework.TileEntityPump;
import glenn.gasesframework.TileEntityTank;
import glenn.gasesframework.client.RenderBlockGas;
import glenn.gasesframework.client.RenderBlockGasPipe;
import glenn.gasesframework.client.RenderBlockLantern;
import glenn.gasesframework.client.RenderBlockPump;
import glenn.gasesframework.client.RenderBlockTank;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionEmpty;
import glenn.gasesframework.reaction.ReactionIgnition;
import glenn.gasesframework.util.QueuedLanternRecipe;
import java.util.ArrayList;
import net.minecraftforge.common.Configuration;

@Mod(modid="gasesFramework", name="Gases Framework", version="1.0.1", dependencies="required-after:gasesFrameworkCore")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class GasesFramework {
    @Mod.Instance(value="gasesFramework")
    public static GasesFramework instance;
    @SidedProxy(clientSide="glenn.gasesframework.client.ClientProxy", serverSide="glenn.gasesframework.CommonProxy")
    public static CommonProxy proxy;
    public static final GuiHandler guiHandler;
    public static final String version = "1.0.1";
    public static float gasExplosionFactor;
    public static int gasFurnaceHeatingSpeed;
    private static boolean preInited;
    private static ArrayList<QueuedLanternRecipe> queuedLanternRecipes;
    private static Configuration config;
    public static int renderBlockGasID;
    public static int renderBlockLanternID;
    public static int renderBlockGasPipeID;
    public static int renderBlockPumpID;
    public static int renderBlockTankID;
    public static bjl gasOverlayImage;
    public static bjl fireOverlayImage;
    private static boolean ENCOURAGE_MECHANICAL_ITEMS_VAR;
    private static boolean ENCOURAGE_LANTERNS_VAR;
    public static final ajz gasMaterial;
    private static boolean[] gasReactives;
    private static ArrayList<Reaction> reactions;
    public static BlockGas gasSmoke;
    public static BlockGas gasFire;
    public static BlockGasPipe gasPipeSmoke;
    public static GasType gasTypeSmoke;
    public static GasType gasTypeFire;
    public static yb gasBottle;
    public static yb gasSamplerIncluder;
    public static yb gasSamplerExcluder;
    public static BlockGasPipe gasPipeAir;
    public static aqw gasPump;
    public static aqw gasTank;
    public static aqw gasCollector;
    public static aqw gasFurnaceIdle;
    public static aqw gasFurnaceActive;
    public static int lanternEmptyID;
    public static BlockLantern lanternEmpty;
    public static BlockLantern lanternGasEmpty;
    public static BlockLantern lanternGas1;
    public static BlockLantern lanternGas2;
    public static BlockLantern lanternGas3;
    public static BlockLantern lanternGas4;
    public static BlockLantern lanternGas5;
    public static GasType gasTypeAir;
    public static wv creativeTab;

    private void initBlocksAndItems() {
        gasBottle = new ItemGasBottle(GasesFramework.b("gasBottleID", 400)).b("gasBottle").a(creativeTab).d("gasesframework:gas_bottle");
        GameRegistry.registerItem((yb)gasBottle, (String)"gasBottle");
        gasSmoke = (BlockGas)new BlockGas(GasesFramework.a("gasSmokeID", 500)).c("gasSmoke").a(creativeTab);
        GameRegistry.registerBlock((aqw)gasSmoke, (String)"gasSmoke");
        gasFire = (BlockGas)new BlockGasFire(GasesFramework.a("gasFireID", 500)).a(0.5f).c("gasFire").a(creativeTab).d("gasesframework:gas_fire");
        GameRegistry.registerBlock((aqw)gasFire, (String)"gasFire");
        if (GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            gasSamplerIncluder = new ItemGasSampler(GasesFramework.b("gasSamplerIncluderID", 401), false).b("gasSamplerIncluder").a(creativeTab).d("gasesframework:sampler");
            GameRegistry.registerItem((yb)gasSamplerIncluder, (String)"gasSamplerIncluder");
            gasSamplerExcluder = new ItemGasSampler(GasesFramework.b("gasSamplerExcluderID", 402), true).b("gasSamplerExcluder").a(creativeTab).d("gasesframework:sampler");
            GameRegistry.registerItem((yb)gasSamplerExcluder, (String)"gasSamplerExcluder");
            gasPipeAir = (BlockGasPipe)new BlockGasPipe(GasesFramework.a("gasPipeAirID", 525)).a(creativeTab).c("gasPipeEmpty");
            GameRegistry.registerBlock((aqw)gasPipeAir, (String)"gasPipeAir");
            gasPipeSmoke = (BlockGasPipe)new BlockGasPipe(GasesFramework.a("gasPipeSmokeID", 526)).c("gasPipeSmoke");
            GameRegistry.registerBlock((aqw)gasPipeSmoke, (String)"gasPipeSmoke");
            gasPump = new BlockGasPump(GasesFramework.a("gasPumpID", 540)).c(2.5f).a(creativeTab).c("gasPump").d("gasesframework:pump");
            GameRegistry.registerBlock((aqw)gasPump, (String)"gasPump");
            gasTank = new BlockGasTank(GasesFramework.a("gasTankID", 541)).c(3.5f).a(creativeTab).c("gasTank").d("gasesframework:tank");
            GameRegistry.registerBlock((aqw)gasTank, (String)"gasTank");
            gasCollector = new BlockGasCollector(GasesFramework.a("gasCollectorID", 542)).c(2.5f).a(creativeTab).c("gasCollector").d("gasesframework:collector");
            GameRegistry.registerBlock((aqw)gasCollector, (String)"gasCollector");
            gasFurnaceIdle = new BlockGasFurnace(GasesFramework.a("gasFurnaceIdleID", 543), false).c(3.5f).a(aqw.k).c("gasFurnace").a(creativeTab);
            GameRegistry.registerBlock((aqw)gasFurnaceIdle, (String)"gasFurnaceIdle");
            gasFurnaceActive = new BlockGasFurnace(GasesFramework.a("gasFurnaceActiveID", 544), true).c(3.5f).a(aqw.k).a(0.25f).c("gasFurnace");
            GameRegistry.registerBlock((aqw)gasFurnaceActive, (String)"gasFurnaceActive");
        }
        gasTypeAir = new GasTypeAir();
        gasTypeSmoke = new GasType(gasSmoke, gasPipeSmoke, 1, "Smoke", 0x3F3F3F, 2, -16, Combustibility.NONE).setEffectRates(4, 4, 0);
        gasTypeFire = new GasTypeFire(gasFire, 11).setEvaporationRate(2);
        lanternEmptyID = GasesFramework.a("lanternEmptyID", 550);
        lanternEmpty = (BlockLantern)new BlockLanternEmpty(lanternEmptyID).c(0.0f).c("lanternEmpty").a(creativeTab).d("gasesframework:lantern_empty");
        GameRegistry.registerBlock((aqw)lanternEmpty, (String)"lanternEmpty");
        if (GasesFramework.LANTERNS_ENCOURAGED()) {
            lanternGasEmpty = (BlockLantern)new BlockLanternSpecial(GasesFramework.a("lanternGasEmptyID", 552), 0, new yd(yb.bv), new yd(yb.bv), null).c("lanternGasEmpty").d("gasesframework:lantern_gas0_off");
            GameRegistry.registerBlock((aqw)lanternGasEmpty, (String)"lanternGasEmpty");
            lanternGas1 = (BlockLantern)new BlockLantern(GasesFramework.a("lanternGas1ID", 553), Combustibility.CONTROLLABLE).a(1.0f).c("lanternGas1").d("gasesframework:lantern_gas0_on");
            GameRegistry.registerBlock((aqw)lanternGas1, (String)"lanternGas1");
            lanternGas2 = (BlockLantern)new BlockLantern(GasesFramework.a("lanternGas2ID", 555), Combustibility.FLAMMABLE).a(1.0f).c("lanternGas2").d("gasesframework:lantern_gas0_on");
            GameRegistry.registerBlock((aqw)lanternGas2, (String)"lanternGas2");
            lanternGas3 = (BlockLantern)new BlockLantern(GasesFramework.a("lanternGas3ID", 557), Combustibility.HIGHLY_FLAMMABLE).a(1.0f).c("lanternGas3").d("gasesframework:lantern_gas0_on");
            GameRegistry.registerBlock((aqw)lanternGas3, (String)"lanternGas3");
            lanternGas4 = (BlockLantern)new BlockLantern(GasesFramework.a("lanternGas4ID", 558), Combustibility.EXPLOSIVE).a(1.0f).c("lanternGas4").d("gasesframework:lantern_gas0_on");
            GameRegistry.registerBlock((aqw)lanternGas4, (String)"lanternGas4");
            lanternGas5 = (BlockLantern)new BlockLantern(GasesFramework.a("lanternGas5ID", 559), Combustibility.HIGHLY_EXPLOSIVE).a(1.0f).c("lanternGas5").d("gasesframework:lantern_gas0_on");
            GameRegistry.registerBlock((aqw)lanternGas5, (String)"lanternGas5");
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] additionalIgnitionBlocks;
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.initBlocksAndItems();
        gasExplosionFactor = Float.parseFloat(config.get("gases", "gasExplosionFactor", 2.5).getString());
        gasFurnaceHeatingSpeed = config.get("other", "gasFurnaceHeatingSpeed", 2).getInt();
        for (String s : additionalIgnitionBlocks = config.get("other", "additionalIgnitionBlocks", new String[0]).getStringList()) {
            GasesFramework.registerIgnitionBlock(Integer.parseInt(s));
        }
        config.save();
        preInited = true;
        for (QueuedLanternRecipe recipe : queuedLanternRecipes) {
            recipe.register();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        renderBlockGasID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockGasID, (ISimpleBlockRenderingHandler)new RenderBlockGas());
        renderBlockLanternID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockLanternID, (ISimpleBlockRenderingHandler)new RenderBlockLantern());
        renderBlockGasPipeID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockGasPipeID, (ISimpleBlockRenderingHandler)new RenderBlockGasPipe());
        renderBlockPumpID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockPumpID, (ISimpleBlockRenderingHandler)new RenderBlockPump());
        renderBlockTankID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((int)renderBlockTankID, (ISimpleBlockRenderingHandler)new RenderBlockTank());
        GameRegistry.addRecipe((yd)new yd((aqw)lanternEmpty, 4), (Object[])new Object[]{"I", "G", Character.valueOf('I'), yb.q, Character.valueOf('G'), aqw.R});
        LanguageRegistry.addName((Object)((Object)lanternEmpty), (String)"Lantern");
        if (GasesFramework.LANTERNS_ENCOURAGED()) {
            LanguageRegistry.addName((Object)((Object)lanternGasEmpty), (String)"Empty Gas Lantern");
            LanguageRegistry.addName((Object)((Object)lanternGas1), (String)"Gas Lantern");
            LanguageRegistry.addName((Object)((Object)lanternGas2), (String)"Gas Lantern");
            LanguageRegistry.addName((Object)((Object)lanternGas3), (String)"Gas Lantern");
            LanguageRegistry.addName((Object)((Object)lanternGas4), (String)"Gas Lantern");
            LanguageRegistry.addName((Object)((Object)lanternGas5), (String)"Gas Lantern");
        }
        if (GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            GameRegistry.addRecipe((yd)new yd((aqw)gasPipeAir, 24), (Object[])new Object[]{"III", Character.valueOf('I'), yb.q});
            GameRegistry.addRecipe((yd)new yd(gasPump), (Object[])new Object[]{" I ", "PRP", " I ", Character.valueOf('I'), yb.q, Character.valueOf('P'), gasPipeAir, Character.valueOf('R'), yb.aE});
            GameRegistry.addRecipe((yd)new yd(gasCollector), (Object[])new Object[]{" P ", "PUP", " P ", Character.valueOf('U'), gasPump, Character.valueOf('P'), gasPipeAir});
            GameRegistry.addRecipe((yd)new yd(gasTank), (Object[])new Object[]{"IPI", "P P", "IPI", Character.valueOf('I'), yb.q, Character.valueOf('P'), gasPipeAir});
            GameRegistry.addRecipe((yd)new yd(gasFurnaceIdle), (Object[])new Object[]{" I ", "IFI", " I ", Character.valueOf('I'), yb.q, Character.valueOf('F'), aqw.aG});
            GameRegistry.addShapelessRecipe((yd)new yd(gasSamplerExcluder), (Object[])new Object[]{new yd(yb.bv), new yd(yb.aY, 1, 0)});
            GameRegistry.addShapelessRecipe((yd)new yd(gasSamplerIncluder), (Object[])new Object[]{new yd(yb.bv), new yd(yb.aY, 1, 15)});
            LanguageRegistry.addName((Object)gasPipeAir, (String)"Gas Pipe");
            LanguageRegistry.addName((Object)gasFurnaceIdle, (String)"Gas Furnace");
            LanguageRegistry.addName((Object)gasPump, (String)"Gas Pump");
            LanguageRegistry.addName((Object)gasTank, (String)"Gas Tank");
            LanguageRegistry.addName((Object)gasCollector, (String)"Gas Collector");
            GameRegistry.registerTileEntity(TileEntityPump.class, (String)"gasPump");
            GameRegistry.registerTileEntity(TileEntityGasCollector.class, (String)"gasCollector");
            GameRegistry.registerTileEntity(TileEntityTank.class, (String)"gasTank");
            GameRegistry.registerTileEntity(TileEntityGasFurnace.class, (String)"gasPoweredFurnace");
        }
        GasesFramework.registerIgnitionBlock(aqw.av.cF);
        GasesFramework.registerIgnitionBlock(aqw.aw.cF);
        GasesFramework.registerIgnitionBlock(GasesFramework.gasFire.cF);
        GasesFramework.registerReaction(new ReactionIgnition());
        LanguageRegistry.addName((Object)gasSmoke, (String)"Smoke");
        LanguageRegistry.addName((Object)gasFire, (String)"Ignited Gas");
        LanguageRegistry.addName((Object)gasBottle, (String)"Bottle of Gas");
        LanguageRegistry.instance().addStringLocalization("itemGroup.tabGases", "en_US", "Glenn's Gases");
        proxy.registerRenderers();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    private static int a(String name, int def) {
        return config.getBlock(name, def).getInt();
    }

    private static int b(String name, int def) {
        return config.getItem(name, def).getInt();
    }

    public static void registerIgnitionBlock(int blockID) {
        GasesFramework.gasReactives[blockID] = true;
    }

    public static void unregisterIgnitionBlock(int blockID) {
        GasesFramework.gasReactives[blockID] = false;
    }

    public static boolean isIgnitionBlock(int blockID) {
        return gasReactives[blockID];
    }

    public static void registerReaction(Reaction reaction) {
        if (!reaction.isErroneous()) {
            reactions.add(reaction);
        }
    }

    public static Reaction getReactionForBlocks(int block1ID, int block2ID) {
        for (Reaction reaction : reactions) {
            if (!reaction.is(block1ID, block2ID)) continue;
            return reaction;
        }
        return new ReactionEmpty();
    }

    public static int reverseDirection(int direction) {
        return direction / 2 * 2 + 1 - direction % 2;
    }

    public static void addSpecialFurnaceRecipe(yd ingredient, yd result, int cookTime) {
        if (!GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            throw new RuntimeException("A furnace recipe was registered while mechanical items were not encouraged. Please put GasesFramework.ENCOURAGE_MECHANICAL_ITEMS() in the mod's static initalizer.");
        }
        TileEntityGasFurnace.specialFurnaceRecipes.add(new TileEntityGasFurnace.SpecialFurnaceRecipe(ingredient, result, cookTime));
    }

    public static void queueLanternRecipe(yd result, yd ingredient) {
        if (!GasesFramework.LANTERNS_ENCOURAGED()) {
            throw new RuntimeException("A lantern recipe was registered while lanterns were not encouraged. Please put GasesFramework.ENCOURAGE_LANTERNS() in the mod's static initalizer.");
        }
        if (preInited) {
            GameRegistry.addShapelessRecipe((yd)result, (Object[])new Object[]{new yd((aqw)lanternEmpty), ingredient});
        } else {
            queuedLanternRecipes.add(new QueuedLanternRecipe(result, ingredient));
        }
    }

    public static void ENCOURAGE_MECHANICAL_ITEMS() {
        ENCOURAGE_MECHANICAL_ITEMS_VAR = true;
    }

    public static void ENCOURAGE_LANTERNS() {
        ENCOURAGE_LANTERNS_VAR = true;
    }

    public static boolean MECHANICAL_ITEMS_ENCOURAGED() {
        return ENCOURAGE_MECHANICAL_ITEMS_VAR;
    }

    public static boolean LANTERNS_ENCOURAGED() {
        return ENCOURAGE_LANTERNS_VAR;
    }

    static {
        guiHandler = new GuiHandler();
        preInited = false;
        queuedLanternRecipes = new ArrayList();
        gasOverlayImage = new bjl("gasesframework:textures/misc/gas_overlay.png");
        fireOverlayImage = new bjl("gasesframework:textures/misc/fire_overlay.png");
        ENCOURAGE_MECHANICAL_ITEMS_VAR = false;
        ENCOURAGE_LANTERNS_VAR = false;
        gasMaterial = new ajz(akb.b){

            public boolean a() {
                return false;
            }

            public boolean c() {
                return false;
            }
        }.i();
        gasReactives = new boolean[aqw.s.length];
        reactions = new ArrayList();
        creativeTab = new wv("tabGases"){

            public yd getIconItemStack() {
                return new yd((aqw)lanternEmpty, 1, 0);
            }
        };
    }
}

