/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import cpw.mods.fml.common.registry.GameRegistry;
import glenn.gasesframework.BlockGas;
import glenn.gasesframework.BlockGasPipe;
import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasesFramework;

public class GasType {
    public static final GasType[] gasTypes = new GasType[256];
    public final BlockGas gasBlock;
    public final BlockGasPipe gasPipe;
    public final int gasIndex;
    public final String name;
    public final int color;
    public final int opacity;
    public final int density;
    public final Combustibility combustibility;
    public int evaporationRate;
    public float damage;
    public int blindnessRate;
    public int suffocationRate;
    public int slownessRate;

    public GasType(BlockGas gasBlock, BlockGasPipe gasPipe, int gasIndex, String name, int color, int opacity, int density, Combustibility combustibility) {
        this.gasBlock = gasBlock;
        this.gasPipe = gasPipe;
        this.gasIndex = gasIndex;
        this.name = name;
        this.color = color;
        this.opacity = opacity;
        this.density = density;
        this.combustibility = combustibility;
        this.evaporationRate = 0;
        this.damage = 0.0f;
        this.blindnessRate = 0;
        this.suffocationRate = 0;
        this.slownessRate = 0;
        if (gasBlock != null) {
            gasBlock.type = this;
            gasBlock.k(opacity);
        }
        if (gasPipe != null) {
            gasPipe.type = this;
        }
        if (gasBlock != null & (combustibility.fireSpreadRate >= 0 | combustibility.explosionPower > 0.0f)) {
            BlockGas.setBurnProperties((int)gasBlock.cF, (int)1000, (int)1000);
        }
        if (combustibility.lanternBlock != null) {
            GameRegistry.addShapelessRecipe((yd)new yd((aqw)combustibility.lanternBlock), (Object[])new Object[]{new yd((aqw)GasesFramework.lanternEmpty), new yd(GasesFramework.gasBottle, 1, gasIndex)});
        }
        if (gasTypes[gasIndex] != null) {
            System.out.println("A gas named " + name + " has overridden a gas at gas index " + gasIndex);
        }
        GasType.gasTypes[gasIndex] = this;
    }

    public GasType(BlockGas gasBlock, int gasIndex, String name, int color, int opacity, int density, Combustibility combustibility) {
        this(gasBlock, null, gasIndex, name, color, opacity, density, combustibility);
    }

    public GasType setEffectRates(int blindness, int suffocation, int slowness) {
        this.blindnessRate = blindness;
        this.suffocationRate = suffocation;
        this.slownessRate = slowness;
        return this;
    }

    public GasType setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public GasType setEvaporationRate(int evaporation) {
        this.evaporationRate = evaporation;
        return this;
    }

    public yd getBottledItem() {
        return new yd(GasesFramework.gasBottle, 1, this.gasIndex);
    }

    public void onBreathed(oe entity) {
        entity.a(na.j, 0.5f);
    }

    public void onTouched(nm entity) {
        if (this.damage > 0.0f) {
            entity.a(na.j, this.damage);
        }
    }

    public boolean isIndustrial() {
        return this.gasPipe != null;
    }

    public bjl getOverlayImage() {
        return GasesFramework.gasOverlayImage;
    }
}

