/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.IGasReceptor;
import glenn.gasesframework.IGasSource;
import glenn.gasesframework.util.PipeBranch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class BlockGasPipe
extends aqw
implements IGasReceptor {
    private static final int[] xDirection = new int[]{0, 0, 1, -1, 0, 0};
    private static final int[] yDirection = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] zDirection = new int[]{0, 0, 0, 0, 1, -1};
    public GasType type;

    public BlockGasPipe(int blockID) {
        super(blockID, ajz.f);
        if (!GasesFramework.MECHANICAL_ITEMS_ENCOURAGED()) {
            throw new RuntimeException("A gas pipe block was created while mechanical items were not encouraged. Please put GasesFramework.ENCOURAGE_MECHANICAL_ITEMS() in the mod's static initalizer.");
        }
        this.c(1.0f);
        this.d("gasesframework:pipe");
    }

    public boolean[] getRenderConnectionArray(ace blockAccess, int x, int y, int z) {
        boolean[] sidePipe = new boolean[6];
        boolean[] renderConnections = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            int x1 = x + xDirection[i];
            int y1 = y + yDirection[i];
            int z1 = z + zDirection[i];
            int directionBlockID = blockAccess.a(x1, y1, z1);
            if (directionBlockID == 0) continue;
            aqw directionBlock = aqw.s[directionBlockID];
            sidePipe[i] = directionBlock instanceof BlockGasPipe || IGasReceptor.class.isAssignableFrom(directionBlock.getClass());
        }
        boolean collectionAll = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionY = sidePipe[2] || sidePipe[3] || sidePipe[4] || sidePipe[5];
        boolean collectionX = sidePipe[0] || sidePipe[1] || sidePipe[4] || sidePipe[5];
        boolean collectionZ = sidePipe[0] || sidePipe[1] || sidePipe[2] || sidePipe[3];
        renderConnections[0] = (sidePipe[3] | !collectionX) & collectionAll;
        renderConnections[1] = (sidePipe[2] | !collectionX) & collectionAll;
        renderConnections[2] = (sidePipe[0] | !collectionY) & collectionAll;
        renderConnections[3] = (sidePipe[1] | !collectionY) & collectionAll;
        renderConnections[4] = (sidePipe[5] | !collectionZ) & collectionAll;
        renderConnections[5] = (sidePipe[4] | !collectionZ) & collectionAll;
        return renderConnections;
    }

    public void a(abv world, int x, int y, int z, asu axisAlignedBB, List list, nm entity) {
        boolean[] renderConnections = this.getRenderConnectionArray((ace)world, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        float minX = renderConnections[0] ? 0.0f : f1;
        float maxX = renderConnections[1] ? 1.0f : f2;
        float minY = renderConnections[2] ? 0.0f : f1;
        float maxY = renderConnections[3] ? 1.0f : f2;
        float minZ = renderConnections[4] ? 0.0f : f1;
        float maxZ = renderConnections[5] ? 1.0f : f2;
        this.a(f1, f1, minZ, f2, f2, maxZ);
        super.a(world, x, y, z, axisAlignedBB, list, entity);
        this.a(f1, minY, f1, f2, maxY, f2);
        super.a(world, x, y, z, axisAlignedBB, list, entity);
        this.a(minX, f1, f1, maxX, f2, f2);
        super.a(world, x, y, z, axisAlignedBB, list, entity);
        this.a((ace)world, x, y, z);
    }

    public void a(ace blockAccess, int x, int y, int z) {
        boolean[] renderConnections = this.getRenderConnectionArray(blockAccess, x, y, z);
        float f1 = 0.375f;
        float f2 = 0.625f;
        float minX = renderConnections[0] ? 0.0f : f1;
        float maxX = renderConnections[1] ? 1.0f : f2;
        float minY = renderConnections[2] ? 0.0f : f1;
        float maxY = renderConnections[3] ? 1.0f : f2;
        float minZ = renderConnections[4] ? 0.0f : f1;
        float maxZ = renderConnections[5] ? 1.0f : f2;
        this.a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private void fillArrayWithIndices(Random rand, int[] indices, int length, int start, int arrayTranslate) {
        for (int i = 0; i < length; ++i) {
            int index;
            while (indices[index = arrayTranslate + rand.nextInt(length)] != 0) {
            }
            indices[index] = start + i;
        }
    }

    private void shuffleArray(Random random, PipeBranch[] array, int limit) {
        for (int i = limit; i > 0; --i) {
            int otherIndex = random.nextInt(i + 1);
            PipeBranch pipeBranch = array[otherIndex];
            array[otherIndex] = array[i];
            array[i] = pipeBranch;
        }
    }

    @Override
    public boolean receiveGas(abv world, int x, int y, int z, int side, GasType gasType) {
        int i;
        ArrayList<PipeBranch> branches = new ArrayList<PipeBranch>();
        ArrayList<PipeBranch> looseEnds = new ArrayList<PipeBranch>();
        ArrayList<PipeBranch> ends = new ArrayList<PipeBranch>();
        branches.add(new PipeBranch(0, 0, 0, side));
        boolean stop = false;
        while (branches.size() > 0 & !stop) {
            int branchAmount = branches.size();
            i = 0;
            while (i < branchAmount & !stop) {
                int z2;
                int y2;
                int x2;
                int j;
                PipeBranch branch = (PipeBranch)branches.get(i);
                PipeBranch[] newBranches = new PipeBranch[6];
                int subBranches = 0;
                int connectedSurroundingBlocks = 0;
                int x1 = x + branch.x;
                int y1 = y + branch.y;
                int z1 = z + branch.z;
                for (j = 0; j < 6; ++j) {
                    if (j == branch.getReverseDirection()) continue;
                    x2 = x1 + xDirection[j];
                    y2 = y1 + yDirection[j];
                    z2 = z1 + zDirection[j];
                    boolean notBranched = true;
                    for (int k = 0; k < branchAmount; ++k) {
                        if (k == i || !((PipeBranch)branches.get(k)).holds(x2 - x, y2 - y, z2 - z)) continue;
                        notBranched = false;
                        break;
                    }
                    int directionBlockID = world.a(x2, y2, z2);
                    aqw directionBlock = aqw.s[directionBlockID];
                    int directionBlockMetadata = world.h(x2, y2, z2);
                    if (directionBlock == null) continue;
                    if (directionBlock instanceof BlockGasPipe) {
                        ++connectedSurroundingBlocks;
                        if (!(branch.length < 15 & notBranched)) continue;
                        newBranches[subBranches++] = branch.branch(j);
                        continue;
                    }
                    if (!IGasReceptor.class.isAssignableFrom(directionBlock.getClass())) continue;
                    ++connectedSurroundingBlocks;
                    ends.add(branch.branch(j));
                }
                if (connectedSurroundingBlocks <= 0) {
                    PipeBranch branch2 = branch.branch(branch.getDirection());
                    x2 = x + branch2.x;
                    y2 = y + branch2.y;
                    z2 = z + branch2.z;
                    if (world.c(x2, y2, z2)) {
                        looseEnds.add(branch2);
                    }
                }
                if (subBranches > 0) {
                    for (j = 0; j < subBranches; ++j) {
                        PipeBranch newBranch = newBranches[j];
                        if (j < 1) {
                            branches.set(i, newBranch);
                            continue;
                        }
                        branches.add(newBranch);
                    }
                } else {
                    branches.remove(i--);
                    --branchAmount;
                }
                ++i;
            }
        }
        PipeBranch pushedEnd = null;
        if (looseEnds.size() > 0) {
            pushedEnd = (PipeBranch)looseEnds.get(world.s.nextInt(looseEnds.size()));
            PipeBranch originPipe = pushedEnd.unBranch();
            BlockGasPipe pipeBlock = (BlockGasPipe)aqw.s[world.a(x + originPipe.x, y + originPipe.y, z + originPipe.z)];
            if (pipeBlock.type.gasBlock != null) {
                world.c(x + pushedEnd.x, y + pushedEnd.y, z + pushedEnd.z, pipeBlock.type.gasBlock.cF);
            }
            pushedEnd = originPipe;
        } else if (ends.size() > 0) {
            Collections.shuffle(ends);
            i = 0;
            while (i < ends.size() & pushedEnd == null) {
                PipeBranch end = (PipeBranch)ends.get(i);
                int x1 = x + end.x;
                int y1 = y + end.y;
                int z1 = z + end.z;
                PipeBranch outPipe = end.unBranch();
                int x2 = x + outPipe.x;
                int y2 = y + outPipe.y;
                int z2 = z + outPipe.z;
                IGasReceptor endBlock = (IGasReceptor)aqw.s[world.a(x1, y1, z1)];
                GasType outGasType = null;
                aqw sourceBlock = aqw.s[world.a(x2, y2, z2)];
                if (sourceBlock instanceof BlockGasPipe) {
                    outGasType = ((BlockGasPipe)sourceBlock).type;
                } else if (IGasSource.class.isAssignableFrom(sourceBlock.getClass())) {
                    outGasType = ((IGasSource)sourceBlock).takeGasTypeFromSide(world, x2, y2, z2, outPipe.getReverseDirection());
                }
                if (endBlock.receiveGas(world, x1, y1, z1, end.getDirection(), outGasType)) {
                    pushedEnd = end.unBranch();
                }
                ++i;
            }
        }
        if (pushedEnd != null) {
            while (pushedEnd.length > 1) {
                int x1 = x + pushedEnd.x;
                int y1 = y + pushedEnd.y;
                int z1 = z + pushedEnd.z;
                int block1 = world.a(x1, y1, z1);
                pushedEnd = pushedEnd.unBranch();
                int block2 = world.a(x + pushedEnd.x, y + pushedEnd.y, z + pushedEnd.z);
                if (block1 == block2) continue;
                world.c(x1, y1, z1, block2);
            }
            world.c(x, y, z, gasType.gasPipe.cF);
        }
        return pushedEnd != null;
    }

    public void a(abv world, int x, int y, int z, int neighboutBlockID) {
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public int d() {
        return GasesFramework.renderBlockGasPipeID;
    }

    public int d(abv par1World, int par2, int par3, int par4) {
        return GasesFramework.gasPipeAir.cF;
    }

    public void a(abv world, int x, int y, int z, int oldBlockID, int oldBlockMetadata) {
        if (this.type.gasBlock != null && world.c(x, y, z)) {
            world.c(x, y, z, this.type.gasBlock.cF);
        }
    }
}

