/*
 * Decompiled with CFR 0.152.
 */
package glenn.gasesframework;

import glenn.gasesframework.Combustibility;
import glenn.gasesframework.GasType;
import glenn.gasesframework.GasesFramework;
import glenn.gasesframework.ISample;
import glenn.gasesframework.reaction.Reaction;
import glenn.gasesframework.reaction.ReactionEmpty;
import java.util.Random;

public class BlockGas
extends aqw
implements ISample {
    public GasType type;
    private static final int[] ringsX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 2, 0, -2, 0};
    private static final int[] ringsZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 2, 0, -2};
    private static final int[] ringX = new int[]{0, 0, -1, 1, 0, 0};
    private static final int[] ringY = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] ringZ = new int[]{0, 0, 0, 0, -1, 1};
    private static final int[] movesX = new int[]{1, 0, -1, 0, 1, -1, -1, 1, 1, 0, -1, 0};
    private static final int[] movesZ = new int[]{0, 1, 0, -1, 1, 1, -1, -1, 0, 1, 0, -1};

    public BlockGas(int id) {
        super(id, GasesFramework.gasMaterial);
        this.b(true);
        this.C();
        this.c(0.0f);
        this.d("gasesframework:gas");
    }

    public asu c_(abv world, int i, int j, int k) {
        int metadata = world.h(i, j, k);
        double minY = this.getMinY((ace)world, i, j, k, metadata);
        double maxY = this.getMaxY((ace)world, i, j, k, metadata);
        return asu.a().a((double)i, (double)j + minY, (double)k, (double)i + 1.0, (double)j + maxY, (double)k + 1.0);
    }

    public void a(abv par1World, int par2, int par3, int par4, nm par5Entity) {
        this.type.onTouched(par5Entity);
    }

    public int c(ace par1IBlockAccess, int par2, int par3, int par4) {
        return this.type.color;
    }

    public int b(int metadata) {
        return this.type.color;
    }

    public boolean b() {
        return false;
    }

    public boolean c() {
        return false;
    }

    public boolean a(int par1, boolean par2) {
        return par2 && par1 == 0;
    }

    public boolean a_(ace par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    public boolean a(ace blockAccess, int i, int j, int k, int side) {
        int yDirection;
        int xDirection;
        int n = side == 4 ? 1 : (xDirection = side == 5 ? -1 : 0);
        int n2 = side == 0 ? 1 : (yDirection = side == 1 ? -1 : 0);
        int zDirection = side == 2 ? 1 : (side == 3 ? -1 : 0);
        int metadata = blockAccess.h(i, j, k);
        int directionBlockID = blockAccess.a(i + xDirection, j + yDirection, k + zDirection);
        int directionBlockMetadata = blockAccess.h(i + xDirection, j + yDirection, k + zDirection);
        if (side == 1) {
            aqw block = aqw.s[directionBlockID];
            if (block instanceof BlockGas) {
                double maxY = ((BlockGas)block).getMaxY(blockAccess, i, j, k, directionBlockMetadata);
                return maxY - 1.0 != this.getMinY(blockAccess, i, j, k, metadata);
            }
            return true;
        }
        if (side == 0) {
            aqw block = aqw.s[directionBlockID];
            if (block instanceof BlockGas) {
                double minY = ((BlockGas)block).getMinY(blockAccess, i, j, k, directionBlockMetadata);
                return minY != this.getMaxY(blockAccess, i, j, k, metadata) - 1.0;
            }
            return true;
        }
        return true;
    }

    public final double sideIndent(ace par1IBlockAccess, int par2, int par3, int par4) {
        return par1IBlockAccess.t(par2, par3, par4) ? 0.001 : 0.0;
    }

    public double getMinY(ace blockAccess, int i, int j, int k, int metadata) {
        if (this.type.density > 0) {
            return 0.0;
        }
        if (this.type.density < 0) {
            return (double)metadata / 16.0;
        }
        if (blockAccess.a(i, j - 1, k) == this.cF) {
            return 0.0;
        }
        boolean b = blockAccess.a(i, j + 1, k) == this.cF;
        double d = (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d < 0.0 ? 0.0 : d;
    }

    public double getMaxY(ace blockAccess, int i, int j, int k, int metadata) {
        if (this.type.density > 0) {
            return 1.0 - (double)metadata / 16.0;
        }
        if (this.type.density < 0) {
            return 1.0;
        }
        if (blockAccess.a(i, j + 1, k) == this.cF) {
            return 1.0;
        }
        boolean b = blockAccess.a(i, j - 1, k) == this.cF;
        double d = 1.0 - (0.5 - (double)(16 - metadata) / 8.0) * (b ? 2.0 : 1.0);
        return d > 1.0 ? 1.0 : d;
    }

    public asu b(abv par1World, int par2, int par3, int par4) {
        return null;
    }

    public int d() {
        return GasesFramework.renderBlockGasID;
    }

    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int a(Random par1Random) {
        return 0;
    }

    public int a(abv par1World) {
        return 5;
    }

    public int n() {
        return 1;
    }

    protected void onEvaporated(abv world, int i, int j, int k) {
    }

    public boolean onFire(abv world, int i, int j, int k, Random random) {
        if (this.type.combustibility.explosionPower > 0.0f) {
            if (!world.I) {
                float power = (16.0f - (float)world.h(i, j, k)) / 16.0f + 0.25f;
                world.c(i, j, k, 0);
                world.a(null, (double)i + 0.5, (double)j + 0.5, (double)k + 0.5, this.type.combustibility.explosionPower * GasesFramework.gasExplosionFactor * power, true);
            }
            return true;
        }
        if (this.type.combustibility.fireSpreadRate >= 0) {
            int metadata = world.h(i, j, k);
            world.f(i, j, k, GasesFramework.gasFire.cF, metadata, 3);
            return true;
        }
        return false;
    }

    private void mixEqualSortedValues(Random rand, int[] valueList, int[] indexList) {
        int i = 0;
        block0: while (i < valueList.length) {
            int value = valueList[i];
            int j = 1;
            while (j + i <= valueList.length) {
                if (j + i >= valueList.length || valueList[i + j] != value) {
                    int amountOfSwaps = (j - 1) * (j - 1) * 2;
                    for (int k = 0; k < amountOfSwaps; ++k) {
                        int pos2;
                        int pos1 = rand.nextInt(j);
                        if (pos1 == (pos2 = rand.nextInt(j))) continue;
                        int temp = indexList[i + pos1];
                        indexList[i + pos1] = indexList[i + pos2];
                        indexList[i + pos2] = temp;
                    }
                    i += j;
                    continue block0;
                }
                ++j;
            }
        }
    }

    private void fillArrayWithIndices(Random rand, int[] indices, int length, int start, int arrayTranslate) {
        for (int i = 0; i < length; ++i) {
            int index;
            while (indices[index = arrayTranslate + rand.nextInt(length)] != 0) {
            }
            indices[index] = start + i;
        }
    }

    private void reactionsWithSurroundingBlocks(abv world, int x, int y, int z, Reaction[] reactions, int[] reactionIndices, Random random) {
        int[] indices = new int[6];
        this.fillArrayWithIndices(random, indices, 6, 0, 0);
        block0: for (int index = 0; index < reactions.length; ++index) {
            int i = indices[index];
            int xDirection = i < 2 ? i * 2 - 1 : 0;
            int yDirection = i < 4 & i >= 2 ? i * 2 - 5 : 0;
            int zDirection = i >= 4 ? i * 2 - 9 : 0;
            int directionBlockID = world.a(x + xDirection, y + yDirection, z + zDirection);
            Reaction reaction = GasesFramework.getReactionForBlocks(this.cF, directionBlockID);
            for (int j = 0; j < reactions.length; ++j) {
                Reaction reaction2 = reactions[j];
                if (reaction2 == null) {
                    reactions[j] = reaction;
                    reactionIndices[j] = i;
                    continue block0;
                }
                if (reaction2.priority >= reaction.priority) continue;
                for (int k = index - 1; k >= j; --k) {
                    reactions[k + 1] = reactions[k];
                    reactionIndices[k + 1] = reactionIndices[k];
                }
                reactions[j] = reaction;
                reactionIndices[j] = i;
                continue block0;
            }
        }
    }

    protected int getDelayForUpdate(abv world, int x, int y, int z) {
        Reaction reaction = new ReactionEmpty();
        int delay = -1;
        for (int i = 0; i < 6; ++i) {
            int xDirection = i < 2 ? i * 2 - 1 : 0;
            int yDirection = i < 4 & i >= 2 ? i * 2 - 5 : 0;
            int zDirection = i >= 4 ? i * 2 - 9 : 0;
            int directionBlockID = world.a(x + xDirection, y + yDirection, z + zDirection);
            Reaction reaction2 = GasesFramework.getReactionForBlocks(this.cF, directionBlockID);
            if (!reaction.isErroneous() && reaction2.priority >= reaction.priority) continue;
            reaction = reaction2;
            delay = reaction.getDelay(world, x, y, z, x + xDirection, y + yDirection, z + zDirection);
        }
        if (delay == -1) {
            delay = this.type.density > 0 ? (int)(128.0f / (float)this.type.density) : (this.type.density < 0 ? (int)(-128.0f / (float)this.type.density) : 8);
        }
        return delay;
    }

    public void a(abv world, int par2, int par3, int par4, Random random) {
        boolean requiresTick;
        Reaction[] reactions = new Reaction[6];
        int[] reactionIndices = new int[6];
        this.reactionsWithSurroundingBlocks(world, par2, par3, par4, reactions, reactionIndices, random);
        for (int i = 0; i < reactions.length; ++i) {
            int zDirection;
            int index = reactionIndices[i];
            int xDirection = index < 2 ? index * 2 - 1 : 0;
            int yDirection = index < 4 & index >= 2 ? index * 2 - 5 : 0;
            int n = zDirection = index >= 4 ? index * 2 - 9 : 0;
            if (!reactions[i].reactIfPossible(world, random, par2, par3, par4, par2 + xDirection, par3 + yDirection, par4 + zDirection)) continue;
            return;
        }
        int metadata = 16 - world.h(par2, par3, par4) - this.getGasDecay(world, par2, par3, par4, random);
        boolean bl = requiresTick = this.type.evaporationRate > 0;
        if (metadata <= 0) {
            world.i(par2, par3, par4);
            this.onEvaporated(world, par2, par3, par4);
            return;
        }
        if (this.type.density == 0) {
            int i;
            int[] metadataList = new int[6];
            int[] priorityList = new int[6];
            int surroundingAirBlocks = 0;
            int totalFlow = 0;
            int prevMetadata = metadata;
            block1: for (i = 0; i < 6; ++i) {
                int xDirection = ringX[i];
                int yDirection = ringY[i];
                int zDirection = ringZ[i];
                int direction2BlockID = world.a(par2 + xDirection, par3 + yDirection, par4 + zDirection);
                int direction2BlockMetadata = 16 - world.h(par2 + xDirection, par3 + yDirection, par4 + zDirection);
                if (direction2BlockID == 0) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                    totalFlow += 8;
                } else if (direction2BlockID != this.cF) {
                    direction2BlockMetadata = 17;
                } else if (direction2BlockMetadata < metadata - 1) {
                    totalFlow += (metadata - direction2BlockMetadata) / 2;
                }
                for (int j = 0; j < 6; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 4; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block1;
                }
            }
            this.mixEqualSortedValues(random, metadataList, priorityList);
            i = 0;
            while (i < 6 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringX[j];
                int yDirection = ringY[j];
                int zDirection = ringZ[j];
                if (direction2BlockMetadata != 17) {
                    int transaction;
                    int flow;
                    if (direction2BlockMetadata == -1) {
                        flow = prevMetadata / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (transaction < 1) {
                            transaction = 1;
                        }
                        world.f(par2 + xDirection, par3 + yDirection, par4 + zDirection, this.cF, 16 - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        flow = (prevMetadata - direction2BlockMetadata) / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (transaction < 1) {
                            transaction = 1;
                        }
                        world.b(par2 + xDirection, par3 + yDirection, par4 + zDirection, 16 - direction2BlockMetadata - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    }
                }
                ++i;
            }
            if (metadata > 0) {
                world.b(par2, par3, par4, 16 - metadata, 3);
            } else {
                world.c(par2, par3, par4, 0);
            }
            if (requiresTick) {
                world.a(par2, par3, par4, this.cF, 10);
            }
            return;
        }
        int yDirection = this.type.density > 0 ? -1 : 1;
        int directionBlockID = world.a(par2, par3 + yDirection, par4);
        int directionBlockMetadata = 16 - world.h(par2, par3 + yDirection, par4);
        int reverseDirectionBlockID = world.a(par2, par3 - yDirection, par4);
        int reverseDirectionBlockMetadata = 16 - world.h(par2, par3 - yDirection, par4);
        if (directionBlockID == 0) {
            if (metadata > 0) {
                world.f(par2, par3 + yDirection, par4, this.cF, 16 - metadata, 3);
            }
            world.c(par2, par3, par4, 0);
        } else {
            int flow;
            int directionBlockDensity;
            if (directionBlockID != this.cF && aqw.s[directionBlockID] instanceof BlockGas && this.type.density > 0 & this.type.density > (directionBlockDensity = ((BlockGas)aqw.s[directionBlockID]).type.density) | this.type.density < 0 & this.type.density < directionBlockDensity) {
                world.f(par2, par3, par4, directionBlockID, 16 - directionBlockMetadata, 3);
                world.f(par2, par3 + yDirection, par4, this.cF, 16 - metadata, 3);
                return;
            }
            if (directionBlockID == this.cF && directionBlockMetadata < 16) {
                if (directionBlockMetadata + metadata < 16) {
                    world.c(par2, par3, par4, 0);
                    world.b(par2, par3 + yDirection, par4, 16 - directionBlockMetadata - metadata, 3);
                    return;
                }
                world.b(par2, par3, par4, 32 - directionBlockMetadata - metadata, 3);
                world.b(par2, par3 + yDirection, par4, 0, 3);
                metadata -= 16 - directionBlockMetadata;
            }
            if (reverseDirectionBlockID == this.cF) {
                metadata += reverseDirectionBlockMetadata;
            }
            int[] metadataList = new int[4];
            int[] priorityList = new int[4];
            int surroundingAirBlocks = 0;
            int totalFlow = 0;
            int prevMetadata = metadata;
            block5: for (int i = 0; i < 4; ++i) {
                int xDirection = ringsX[i];
                int zDirection = ringsZ[i];
                int direction2BlockID = world.a(par2 + xDirection, par3, par4 + zDirection);
                int direction2BlockMetadata = 16 - world.h(par2 + xDirection, par3, par4 + zDirection);
                if (direction2BlockID == 0) {
                    direction2BlockMetadata = -1;
                    ++surroundingAirBlocks;
                    totalFlow += 8;
                } else if (direction2BlockID != this.cF) {
                    direction2BlockMetadata = 17;
                } else if (direction2BlockMetadata < metadata - 1) {
                    flow = (metadata - direction2BlockMetadata) / 2;
                    if (direction2BlockMetadata + flow > 16) {
                        flow = 16 - direction2BlockMetadata;
                    }
                    totalFlow += flow;
                }
                for (int j = 0; j < 4; ++j) {
                    if (metadataList[j] <= direction2BlockMetadata & j != i) continue;
                    for (int k = 2; k >= j; --k) {
                        metadataList[k + 1] = metadataList[k];
                        priorityList[k + 1] = priorityList[k];
                    }
                    metadataList[j] = direction2BlockMetadata;
                    priorityList[j] = i;
                    continue block5;
                }
            }
            this.mixEqualSortedValues(random, metadataList, priorityList);
            if (metadata < surroundingAirBlocks + 2) {
                int[] indices = new int[ringsX.length];
                this.fillArrayWithIndices(random, indices, 4, 0, 0);
                this.fillArrayWithIndices(random, indices, 4, 4, 4);
                this.fillArrayWithIndices(random, indices, 4, 8, 8);
                for (int index = 0; index < indices.length; ++index) {
                    int direction3BlockID;
                    int i = indices[index];
                    int x = par2 + ringsX[i];
                    int z = par4 + ringsZ[i];
                    int direction2BlockID = world.a(x, par3, z);
                    if (direction2BlockID != 0 || (direction3BlockID = world.a(x, par3 + yDirection, z)) != 0 && (direction3BlockID != this.cF || metadata - world.h(x, par3 + yDirection, z) > 0) || (i >= 8 ? world.a(par2 + movesX[i], par3, par4 + movesZ[i]) != 0 : i >= 4 && world.a(par2 + movesX[i], par3, par4) != 0 && world.a(par2, par3, par4 + movesZ[i]) != 0)) continue;
                    world.c(par2, par3, par4, 0);
                    if (metadata > 0) {
                        world.f(par2 + movesX[i], par3, par4 + movesZ[i], this.cF, 16 - metadata, 3);
                    }
                    return;
                }
            }
            int i = 0;
            while (i < 4 & metadata > 1) {
                int j = priorityList[i];
                int direction2BlockMetadata = metadataList[i];
                int xDirection = ringsX[j];
                int zDirection = ringsZ[j];
                if (direction2BlockMetadata != 17) {
                    int transaction;
                    if (direction2BlockMetadata == -1) {
                        flow = prevMetadata / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (direction2BlockMetadata + transaction > 16) {
                            transaction = 16 - direction2BlockMetadata;
                        } else if (transaction < 1) {
                            transaction = 1;
                        }
                        world.f(par2 + xDirection, par3, par4 + zDirection, this.cF, 16 - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    } else if (direction2BlockMetadata < 16 & direction2BlockMetadata + 1 < metadata) {
                        flow = (prevMetadata - direction2BlockMetadata) / 2;
                        transaction = flow * 16 / (totalFlow + 8);
                        if (direction2BlockMetadata + transaction > 16) {
                            transaction = 16 - direction2BlockMetadata;
                        } else if (transaction < 1) {
                            transaction = 1;
                        }
                        world.b(par2 + xDirection, par3, par4 + zDirection, 16 - direction2BlockMetadata - transaction, 3);
                        requiresTick = false;
                        metadata -= transaction;
                    }
                }
                ++i;
            }
            if (metadata > 16) {
                world.b(par2, par3, par4, 0, 3);
                if (reverseDirectionBlockID == this.cF) {
                    world.b(par2, par3 - yDirection, par4, 32 - metadata, 3);
                }
            } else {
                if (reverseDirectionBlockID == this.cF) {
                    world.c(par2, par3 - yDirection, par4, 0);
                }
                if (metadata > 0) {
                    world.b(par2, par3, par4, 16 - metadata, 3);
                } else {
                    world.c(par2, par3, par4, 0);
                }
            }
        }
        if (requiresTick) {
            world.a(par2, par3, par4, this.cF, this.getDelayForUpdate(world, par2, par3, par4));
        }
    }

    protected int getGasDecay(abv par1World, int par2, int par3, int par4, Random par5Random) {
        return this.type.evaporationRate > 0 && par5Random.nextInt(this.type.evaporationRate) == 0 ? 1 : 0;
    }

    public void a(abv par1World, int par2, int par3, int par4) {
        par1World.a(par2, par3, par4, this.cF, this.getDelayForUpdate(par1World, par2, par3, par4));
    }

    public void a(abv par1World, int par2, int par3, int par4, int par5) {
        this.a(par1World, par2, par3, par4);
    }

    public void onBlockExploded(abv world, int x, int y, int z, abq explosion) {
        this.onFire(world, x, y, z, world.s);
    }

    public boolean l() {
        return false;
    }

    public boolean canCombustNormally() {
        return this.type.combustibility.burnRate >= Combustibility.FLAMMABLE.burnRate;
    }

    @Override
    public GasType sampleInteraction(abv world, int x, int y, int z, GasType in, boolean excludes) {
        return this.type;
    }
}

