/*
 * Decompiled with CFR 0.152.
 */
package com.chunkbase.mod.forge.mods.slimemodssp.display;

import com.chunkbase.mod.forge.mods.slimemodssp.CommonAccess;
import com.chunkbase.mod.forge.mods.slimemodssp.SlimeSpawning;
import com.chunkbase.mod.forge.mods.slimemodssp.chunkdata.ChunkDataAccess;
import com.chunkbase.mod.forge.mods.slimemodssp.display.IDisplay;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public final class Display
implements IDisplay {
    private final Minecraft mc;
    private ChunkDataAccess chunkDataAccess;

    public Display(Minecraft mc, ChunkDataAccess chunkDataAccess) {
        this.mc = mc;
        this.chunkDataAccess = chunkDataAccess;
    }

    @Override
    public void addSlimeInfoToList(List<String> list) {
        String out;
        EntityClientPlayerMP player = this.mc.field_71439_g;
        WorldClient world = this.mc.field_71441_e;
        if (player == null || world == null || this.chunkDataAccess == null || !this.mc.field_71474_y.field_74330_P || !CommonAccess.isInOverworld((Entity)player)) {
            return;
        }
        list.add(null);
        boolean seedCheck = false;
        boolean dataAvailable = false;
        Boolean chunkResult = this.chunkDataAccess.hasSlimeChunk((EntityPlayer)player);
        if (chunkResult != null) {
            dataAvailable = true;
            seedCheck = chunkResult;
        }
        boolean swampCheck = SlimeSpawning.isInSwamp((World)world, (EntityPlayer)player);
        if (!dataAvailable) {
            list.add("Slime Chunk info unavailable");
        }
        if (seedCheck && SlimeSpawning.chunkHeightCheck((EntityPlayer)player)) {
            out = "Yes (Slime Chunk)";
        } else if (swampCheck && SlimeSpawning.swampHeightCheck((EntityPlayer)player)) {
            out = "Yes (Swamp)";
        } else {
            out = "No";
            if (!dataAvailable) {
                out = out + "?";
            }
            if (seedCheck && swampCheck) {
                out = out + " (in Swamp and Slime Chunk, but wrong height)";
            } else if (seedCheck) {
                out = out + " (in Slime Chunk, but wrong height)";
            } else if (swampCheck) {
                out = out + " (in Swamp, but wrong height)";
            }
        }
        Long seed = this.chunkDataAccess.getSeed();
        if (seed != null) {
            String suffix = this.chunkDataAccess.getStatusText();
            suffix = suffix == null ? "" : " (" + suffix + ")";
            list.add("Seed: " + seed + suffix);
        }
        list.add("Slimes: " + out);
        if (swampCheck) {
            String lunar = "Spawn Rate (Swamp): ";
            lunar = lunar + SlimeSpawning.getSwampSpawnRate((World)world) * 100.0f + "% (";
            lunar = lunar + SlimeSpawning.getNextSwampSpawnRate((World)world) * 100.0f + "% in ";
            lunar = lunar + (24000L - world.func_72820_D() % 24000L + 600L) / 1200L;
            lunar = lunar + "m)";
            list.add(lunar);
        }
    }

    @Override
    public void setChunkDataAccess(ChunkDataAccess slimeChunks) {
        this.chunkDataAccess = slimeChunks;
    }
}

