/*
 * Decompiled with CFR 0.152.
 */
package deconstruction.common;

import cpw.mods.fml.common.Loader;
import deconstruction.common.Resources;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.minecraft.util.EnumChatFormatting;

public class UpdateHandler
implements Runnable {
    public static UpdateHandler instance = new UpdateHandler();
    public static final byte UNINITIALIZED = 0;
    public static final byte CURRENT = 1;
    public static final byte OUTDATED = 2;
    public static final byte ERROR = 3;
    public static final byte FINAL_ERROR = 4;
    public static final byte MC_VERSION_NOT_FOUND = 5;
    public static final String REMOTE_VERSION_XML_FILE = "http://pastebin.com/raw.php?i=eZKkKxFX";
    private static byte result = 0;
    public static String remoteVersion = null;
    public static String remoteUpdateLocation = "http://bit.ly/deconTable";
    public static Properties remoteVersionProperties = new Properties();

    @Override
    public void run() {
        System.out.println(Resources.VERSION_CHECK_INIT_LOG_MESSAGE + " " + REMOTE_VERSION_XML_FILE);
        try {
            for (int count = 0; count < Resources.VERSION_CHECK_ATTEMPTS - 1 && (result == 0 || result == 3); ++count) {
                this.checkVersion();
                this.logResult();
                if (result != 0 && result != 3) continue;
                Thread.sleep(10000L);
            }
            if (result == 3) {
                result = (byte)4;
                this.logResult();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void logResult() {
        if (result == 1 || result == 2) {
            System.out.println(UpdateHandler.getResultMessage());
        } else {
            System.out.println(UpdateHandler.getResultMessage());
        }
    }

    public static byte getResult() {
        return result;
    }

    public static String getResultMessage() {
        if (result == 0) {
            return "Remote version check failed to initialize properly";
        }
        if (result == 1) {
            String returnString = Resources.CURRENT_MESSAGE;
            if (returnString.equals("")) {
                returnString = "Currently using the most up to date version (@REMOTE_MOD_VERSION@) of @MOD_NAME@ for @MINECRAFT_VERSION@";
            }
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            return returnString;
        }
        if (result == 2 && remoteVersion != null && remoteUpdateLocation != null) {
            String returnString = Resources.OUTDATED_MESSAGE;
            returnString = returnString.replace("@MOD_NAME@", "deconstruction");
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            returnString = returnString.replace("@MOD_UPDATE_LOCATION@", remoteUpdateLocation);
            return returnString;
        }
        if (result == 2 && remoteVersion != null && remoteUpdateLocation != null) {
            String returnString = Resources.OUTDATED_MESSAGE;
            returnString = returnString.replace("@MOD_NAME@", "deconstruction");
            returnString = returnString.replace("@REMOTE_MOD_VERSION@", remoteVersion);
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            returnString = returnString.replace("@MOD_UPDATE_LOCATION@", remoteUpdateLocation);
            return returnString;
        }
        if (result == 3) {
            return "Error while connecting to remote version file; trying again";
        }
        if (result == 4) {
            return "Version check stopping after @ATTEMPTS@ unsuccessful connection attempts";
        }
        if (result == 5) {
            String returnString = "Unable to find a version of @MOD_NAME@ for @MINECRAFT_VERSION@ in the remote version file";
            returnString = returnString.replace("@MOD_NAME@", "deconstruction");
            returnString = returnString.replace("@MINECRAFT_VERSION@", Loader.instance().getMCVersionString());
            returnString = returnString.replace("@ATTEMPTS@", Integer.toString(Resources.VERSION_CHECK_ATTEMPTS));
            return returnString;
        }
        result = (byte)3;
        return "Error while connecting to remote version file; trying again";
    }

    public static String getResultMessageForClient() {
        String returnString = Resources.OUTDATED_MESSAGE;
        if (returnString.equals("")) {
            returnString = "A new @MOD_NAME@ version exists (@REMOTE_MOD_VERSION@) for @MINECRAFT_VERSION@. Get it here: @MOD_UPDATE_LOCATION@";
        }
        returnString = returnString.replace("@MOD_NAME@", EnumChatFormatting.YELLOW + "Deconstruction Mod" + EnumChatFormatting.WHITE);
        returnString = returnString.replace("@REMOTE_MOD_VERSION@", EnumChatFormatting.YELLOW + remoteVersion + EnumChatFormatting.WHITE);
        returnString = returnString.replace("@MINECRAFT_VERSION@", EnumChatFormatting.YELLOW + Loader.instance().getMCVersionString() + EnumChatFormatting.WHITE);
        returnString = returnString.replace("@MOD_UPDATE_LOCATION@", EnumChatFormatting.YELLOW + remoteUpdateLocation + EnumChatFormatting.WHITE);
        return returnString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVersion() {
        InputStream remoteVersionRepoStream = null;
        result = 0;
        try {
            URL remoteVersionURL = new URL(REMOTE_VERSION_XML_FILE);
            remoteVersionRepoStream = remoteVersionURL.openStream();
            remoteVersionProperties.loadFromXML(remoteVersionRepoStream);
            String remoteVersionProperty = remoteVersionProperties.getProperty(Loader.instance().getMCVersionString());
            if (remoteVersionProperty != null) {
                String[] remoteVersionTokens = remoteVersionProperty.split("\\|");
                if (remoteVersionTokens.length >= 2) {
                    remoteVersion = remoteVersionTokens[0];
                    remoteUpdateLocation = remoteVersionTokens[1];
                } else {
                    result = (byte)3;
                }
                if (remoteVersion != null) {
                    if (!Resources.LAST_DISCOVERED_VERSION.equalsIgnoreCase(remoteVersion)) {
                        Resources.LAST_DISCOVERED_VERSION = remoteVersion;
                    }
                    result = remoteVersion.equalsIgnoreCase("2.1.0") ? (byte)1 : (byte)2;
                }
            } else {
                result = (byte)5;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (result == 0) {
                result = (byte)3;
            }
            try {
                if (remoteVersionRepoStream != null) {
                    remoteVersionRepoStream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    public static void execute() {
        new Thread(instance).start();
    }
}

