/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.helpers.item.ItemHelper;
import bspkrs.util.CommonUtils;
import bspkrs.util.HashCodeUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemID {
    public String id;
    public int damage;

    public ItemID(String id, int damage) {
        this.id = id;
        this.damage = damage;
    }

    public ItemID(String id) {
        this(id, -1);
    }

    public ItemID(ItemStack itemStack, int damage) {
        this(itemStack.func_77973_b(), damage);
    }

    public ItemID(ItemStack itemStack) {
        this(itemStack.func_77973_b(), -1);
    }

    public ItemID(Item item, int damage) {
        this(ItemHelper.getUniqueID(item), damage);
    }

    public ItemID(Item item) {
        this(ItemHelper.getUniqueID(item), -1);
    }

    public ItemID(String format, String delimiter) {
        String[] parts = format.split(delimiter);
        if (parts.length > 1) {
            this.id = parts[0].trim();
            this.damage = CommonUtils.parseInt(parts[1], -1);
        } else {
            this.id = parts[0].trim();
            this.damage = -1;
        }
    }

    public ItemID clone() {
        return new ItemID(this.id, this.damage);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ItemID)) {
            return false;
        }
        ItemID o = (ItemID)obj;
        if (o.damage == -1 || this.damage == -1) {
            return this.id.equals(o.id);
        }
        return this.id.equals(o.id) && this.damage == o.damage;
    }

    public int hashCode() {
        int result = 31;
        result = HashCodeUtil.hash(result, this.id);
        result = HashCodeUtil.hash(result, this.damage);
        return result;
    }

    public String toString() {
        return this.damage == -1 ? this.id + "" : this.id + ", " + this.damage;
    }
}

