/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.worldstatecheckpoints;

import bspkrs.helpers.entity.player.EntityPlayerHelper;
import bspkrs.util.CommonUtils;
import bspkrs.worldstatecheckpoints.WSCSettings;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldServer;

public class CheckpointManager {
    private Minecraft mc;
    private WorldServer world;
    public Properties autoSaveConfig;
    private static Properties autoSaveConfigDefaults = new Properties();
    private File autoConfigFile;
    private File autoConfigDir;
    private OutputStream cfgOutput;
    private InputStream cfgInput;
    public int tickCount;
    public int maxTickCount;
    public boolean autoSaveEnabled;
    public int maxAutoSavesToKeep;
    public boolean isSaving = false;
    public static final String ENABLED = "enabled";
    public static final String MAX_AUTO_SAVE_ID = "maxAutoSaveID";
    public static final String MAX_AUTO_SAVES_TO_KEEP = "maxAutoSavesToKeep";
    public static final String AUTO_SAVE_PERIOD = "autoSavePeriod";
    public static final String PERIOD_UNIT = "periodUnit";
    public static final String UNIT_MINUTES = "minutes";
    public static final String UNIT_HOURS = "hours";
    public static final String UNIT_SECONDS = "seconds";
    public static final String CHECKPOINT_DIR_NAME = "checkpoints";
    public static final String AUTOSAVES_DIR_NAME = "autosaves";
    public static final String AUTOSAVES_PREFIX = "autosave";
    public static final String[] IGNORE_DELETE = new String[]{"checkpoints", "autosaves"};
    public static final String[] IGNORE_COPY = new String[]{"checkpoints", "autosaves", "session.lock"};
    public static final String[] IGNORE_NULL = new String[0];

    public CheckpointManager(Minecraft minecraft) {
        this.mc = minecraft;
        this.world = this.mc.func_71387_A() ? this.mc.func_71401_C().func_71218_a(this.mc.field_71441_e.field_73011_w.field_76574_g) : null;
        autoSaveConfigDefaults.setProperty(ENABLED, WSCSettings.autoSaveEnabledDefault);
        autoSaveConfigDefaults.setProperty(MAX_AUTO_SAVE_ID, "0");
        autoSaveConfigDefaults.setProperty(MAX_AUTO_SAVES_TO_KEEP, WSCSettings.maxAutoSavesToKeepDefault + "");
        autoSaveConfigDefaults.setProperty(AUTO_SAVE_PERIOD, WSCSettings.autoSavePeriodDefault + "");
        autoSaveConfigDefaults.setProperty(PERIOD_UNIT, WSCSettings.periodUnitDefault);
        this.loadAutoConfig();
        this.tickCount = this.maxTickCount - 600;
    }

    public int getNextAutoSaveID() {
        int id = 0;
        try {
            id = Integer.valueOf(this.autoSaveConfig.getProperty(MAX_AUTO_SAVE_ID));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.autoSaveConfig.setProperty(MAX_AUTO_SAVE_ID, String.valueOf(++id));
        this.saveAutoConfig(this.autoSaveConfig);
        return id;
    }

    public void incrementTickCount() {
        if (++this.tickCount >= this.maxTickCount) {
            this.setCheckpoint("", true);
            this.tickCount = 0;
        }
    }

    public void saveAutoConfig(Properties prop) {
        try {
            this.cfgOutput = new FileOutputStream(this.autoConfigFile);
            prop.store(this.cfgOutput, "");
            this.cfgOutput.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void loadAutoConfig() {
        this.autoConfigDir = this.getAutoCheckpointsPath();
        if (!this.autoConfigDir.exists()) {
            this.autoConfigDir.mkdirs();
        }
        this.autoConfigFile = this.chainDirs(this.autoConfigDir.toString(), "autosave.cfg");
        if (!this.autoConfigFile.exists()) {
            try {
                this.autoConfigFile.createNewFile();
                this.saveAutoConfig(autoSaveConfigDefaults);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            this.cfgInput = new FileInputStream(this.autoConfigFile);
            this.autoSaveConfig = new Properties(autoSaveConfigDefaults);
            this.autoSaveConfig.load(this.cfgInput);
            this.cfgInput.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!this.autoSaveConfig.containsKey(MAX_AUTO_SAVES_TO_KEEP)) {
            this.autoSaveConfig.setProperty(MAX_AUTO_SAVES_TO_KEEP, "10");
            this.saveAutoConfig(this.autoSaveConfig);
        }
        this.maxAutoSavesToKeep = Integer.valueOf(this.autoSaveConfig.getProperty(MAX_AUTO_SAVES_TO_KEEP));
        String unit = this.autoSaveConfig.getProperty(PERIOD_UNIT);
        if (unit.equals(UNIT_SECONDS)) {
            this.maxTickCount = Integer.valueOf(this.autoSaveConfig.getProperty(AUTO_SAVE_PERIOD)) * 20;
        } else if (unit.equals(UNIT_HOURS)) {
            this.maxTickCount = Integer.valueOf(this.autoSaveConfig.getProperty(AUTO_SAVE_PERIOD)) * 20 * 60 * 60;
        } else {
            if (!this.autoSaveConfig.getProperty(PERIOD_UNIT).equalsIgnoreCase(UNIT_MINUTES)) {
                this.autoSaveConfig.setProperty(PERIOD_UNIT, UNIT_MINUTES);
                this.saveAutoConfig(this.autoSaveConfig);
            }
            this.maxTickCount = Integer.valueOf(this.autoSaveConfig.getProperty(AUTO_SAVE_PERIOD)) * 20 * 60;
        }
        this.autoSaveEnabled = this.autoSaveConfig.getProperty(ENABLED).equalsIgnoreCase("on");
    }

    public void unloadWorldSilent() {
        this.world = null;
        this.mc.field_71441_e.func_72882_A();
        this.mc.func_71403_a((WorldClient)null);
        this.waitForIntegratedServerShutdown();
    }

    public void unloadWorld(String msg) {
        this.world = null;
        this.mc.field_71441_e.func_72882_A();
        this.mc.func_71353_a((WorldClient)null, msg);
        this.waitForIntegratedServerShutdown();
    }

    private void waitForIntegratedServerShutdown() {
        while (this.mc.func_71387_A()) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startWorld(String folder, String name) {
        this.mc.func_71371_a(folder, name, null);
        this.mc = null;
    }

    public String getWorldSavePath() {
        return this.getWorldPath().getAbsolutePath();
    }

    public String getWorldSaveRelativePath() {
        return "/saves/" + this.world.func_72860_G().func_75760_g();
    }

    public File getWorldPath() {
        return new File(CommonUtils.getMinecraftDir(), this.getWorldSaveRelativePath());
    }

    public String getWorldName() {
        return this.world.func_72912_H().func_76065_j();
    }

    public File getCheckpointsPath(boolean isAutoSave) {
        if (isAutoSave) {
            return this.chainDirs(this.getWorldPath().toString(), AUTOSAVES_DIR_NAME);
        }
        return this.chainDirs(this.getWorldPath().toString(), CHECKPOINT_DIR_NAME);
    }

    public File getAutoCheckpointsPath() {
        return this.chainDirs(this.getWorldPath().toString(), AUTOSAVES_DIR_NAME);
    }

    public void setCheckpoint(String name, boolean isAutoSave) {
        if (!this.isSaving) {
            String checkpointName = isAutoSave ? new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + "!" + AUTOSAVES_PREFIX + " " + this.getNextAutoSaveID() : new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date()) + "!" + name;
            File targetDir = this.chainDirs(this.getCheckpointsPath(isAutoSave).toString(), checkpointName);
            try {
                this.mc.func_71401_C().func_71203_ab().func_72389_g();
                boolean canNotSave = this.world.field_73058_d;
                this.world.field_73058_d = false;
                this.world.func_73044_a(true, null);
                this.world.field_73058_d = canNotSave;
                File worldDir = this.getWorldPath();
                new CheckpointSaver(worldDir, targetDir, IGNORE_COPY, isAutoSave);
                if (isAutoSave && this.maxAutoSavesToKeep > 0 && this.getCheckpointsCount(isAutoSave) > this.maxAutoSavesToKeep) {
                    new OldAutosaveRemover();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                EntityPlayerHelper.addChatMessage((EntityPlayer)this.mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"wsc.chatMessage.saveError", (Object[])new Object[]{targetDir.getName(), CommonUtils.getLogFileName()})));
            }
        } else {
            EntityPlayerHelper.addChatMessage((EntityPlayer)this.mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"wsc.chatMessage.alreadySavingSaveWarning") + " " + StatCollector.func_74838_a((String)"wsc.chatMessage.autoSavePeriodWarning")));
        }
    }

    public void saveCheckpointInto(String dirname) {
        this.saveCheckpointInto(dirname, dirname);
    }

    public void saveCheckpointInto(String dirname_orig, String dirname_new) {
        if (!this.isSaving) {
            this.deleteDirAndContents(this.chainDirs(this.getCheckpointsPath(false).toString(), dirname_orig));
            try {
                this.world.func_73044_a(true, null);
                File worldDir = this.getWorldPath();
                File targetDir = this.chainDirs(this.getCheckpointsPath(false).toString(), dirname_new);
                this.copyDirectory(worldDir, targetDir, IGNORE_COPY);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            EntityPlayerHelper.addChatMessage((EntityPlayer)this.mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"wsc.chatMessage.alreadySavingSaveWarning")));
        }
    }

    public void deleteCheckpoint(String dirname, boolean isAutoSave) {
        this.deleteDirAndContents(this.chainDirs(this.getCheckpointsPath(isAutoSave).toString(), dirname));
    }

    public String getOldestCheckpointDirName(boolean isAutoSave) {
        Object[] files = this.getCheckpointsPath(isAutoSave).listFiles(new DirFilter());
        if (files.length <= 0) {
            return "invalidDirName";
        }
        Arrays.sort(files);
        return ((File)files[0]).getName();
    }

    public void loadCheckpoint(String checkpointName, boolean isAutoSave) {
        if (!this.isSaving) {
            File worldDir = this.getWorldPath();
            String worldName = this.getWorldName();
            File checkpointDir = this.chainDirs(this.getCheckpointsPath(isAutoSave).toString(), checkpointName);
            this.unloadWorld(StatCollector.func_74838_a((String)"wsc.loadWorld.message"));
            this.deleteDirContents(worldDir, IGNORE_DELETE);
            try {
                this.copyDirectory(checkpointDir, worldDir, IGNORE_NULL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.startWorld(worldDir.getName(), worldName);
        } else {
            EntityPlayerHelper.addChatMessage((EntityPlayer)this.mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"wsc.chatmessage.alreadySavingLoadWarning")));
        }
    }

    public File chainDirs(String ... files) {
        if (files.length == 1) {
            return new File(files[0]);
        }
        File tmp = new File(files[0]);
        for (int i = 1; i < files.length; ++i) {
            tmp = new File(tmp, files[i]);
        }
        return tmp;
    }

    public void copyDirectory(File sourceLocation, File targetLocation, String[] ignore) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdirs();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                boolean ignored = false;
                for (String str : ignore) {
                    if (!str.equals(children[i])) continue;
                    ignored = true;
                    break;
                }
                if (ignored) continue;
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), ignore);
            }
        } else {
            boolean ignored = false;
            for (String str : ignore) {
                if (!str.equals(sourceLocation.getName())) continue;
                ignored = true;
                break;
            }
            if (!ignored) {
                int len;
                FileInputStream in = new FileInputStream(sourceLocation);
                FileOutputStream out = new FileOutputStream(targetLocation);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
    }

    public boolean deleteDirAndContents(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDirAndContents(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public boolean deleteDirContents(File dir, String[] ignore) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success;
                boolean ignored = false;
                for (String str : ignore) {
                    if (!str.equals(children[i])) continue;
                    ignored = true;
                    break;
                }
                if (ignored || (success = this.deleteDirContents(new File(dir, children[i]), ignore))) continue;
                return false;
            }
        } else {
            dir.delete();
        }
        return true;
    }

    public int getCheckpointsCount(boolean isAutoSave) {
        File chpdir = this.getCheckpointsPath(isAutoSave);
        return chpdir.listFiles(new DirFilter()) != null ? chpdir.listFiles(new DirFilter()).length : 0;
    }

    public boolean getHasCheckpoints(boolean isAutoSave) {
        return this.getCheckpointsCount(isAutoSave) > 0;
    }

    public File[] getCheckpoints(boolean isAutoSave) {
        Object[] files = this.getCheckpointsPath(isAutoSave).listFiles(new DirFilter());
        if (files.length > 0) {
            Arrays.sort(files);
        }
        List<Object> list = Arrays.asList(files);
        Collections.reverse(list);
        return list.toArray(new File[list.size()]);
    }

    public String getCheckpointDirNameFromDisplayName(String name) {
        List<File> files = Arrays.asList(this.getCheckpoints(false));
        for (File file : files) {
            if (!name.trim().equals(file.getName().split("!", 2)[1])) continue;
            return file.getName();
        }
        files = Arrays.asList(this.getCheckpoints(true));
        for (File file : files) {
            if (!name.trim().equals(file.getName().split("!", 2)[1])) continue;
            return file.getName();
        }
        return null;
    }

    private class OldAutosaveRemover
    implements Runnable {
        Thread t = new Thread((Runnable)this, "OldAutosaveRemover");

        OldAutosaveRemover() {
            this.t.start();
        }

        @Override
        public void run() {
            while (CheckpointManager.this.maxAutoSavesToKeep > 0 && CheckpointManager.this.getCheckpointsCount(true) > CheckpointManager.this.maxAutoSavesToKeep) {
                CheckpointManager.this.deleteCheckpoint(CheckpointManager.this.getOldestCheckpointDirName(true), true);
            }
        }
    }

    private class CheckpointSaver
    implements Runnable {
        File src;
        File tgt;
        String[] ignoreList;
        Thread t;

        CheckpointSaver(File sourceLocation, File targetLocation, String[] ignore, boolean isAutoSave) {
            this.src = sourceLocation;
            this.tgt = targetLocation;
            this.ignoreList = ignore;
            this.t = new Thread((Runnable)this, "DirectoryCopier");
            this.t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!CheckpointManager.this.isSaving) {
                EntityPlayerHelper.addChatMessage((EntityPlayer)((CheckpointManager)CheckpointManager.this).mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"wsc.chatMessage.savingCheckpoint")));
                try {
                    CheckpointManager.this.isSaving = true;
                    CheckpointManager.this.copyDirectory(this.src, this.tgt, this.ignoreList);
                    EntityPlayerHelper.addChatMessage((EntityPlayer)((CheckpointManager)CheckpointManager.this).mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"wsc.chatMessage.checkpointSaved", (Object[])new Object[]{this.tgt.getName().split("!")[1]})));
                    CheckpointManager.this.isSaving = false;
                }
                catch (Throwable e) {
                    EntityPlayerHelper.addChatMessage((EntityPlayer)((CheckpointManager)CheckpointManager.this).mc.field_71439_g, (IChatComponent)new ChatComponentText(StatCollector.func_74837_a((String)"wsc.chatMessage.saveError", (Object[])new Object[]{this.tgt.getName(), CommonUtils.getLogFileName()})));
                    e.printStackTrace();
                }
                finally {
                    CheckpointManager.this.isSaving = false;
                }
            }
        }
    }

    private class DirFilter
    implements FileFilter {
        private DirFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

