/*
 * Decompiled with CFR 0.152.
 */
package me.isuzutsuki.betterfonts.betterfonts;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.minecraft.client.Minecraft;

public class ConfigParser {
    private static final String[] LOGICAL_FONTS = new String[]{"Serif", "SansSerif", "Dialog", "DialogInput", "Monospaced"};
    private Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private Properties cfgProps = new Properties();

    public boolean loadConfig(String fileName) {
        boolean success = false;
        try {
            File cfg = new File(Minecraft.func_71410_x().field_71412_D.getPath() + fileName);
            if (!cfg.exists()) {
                InputStream stream = ConfigParser.class.getResourceAsStream("/config/BetterFonts.cfg");
                if (stream == null) {
                    System.out.println("[BetterFonts]NULL Stream");
                    System.out.println("BetterFonts failed to create new config file.");
                }
                byte[] buffer = new byte[4096];
                try {
                    int readBytes;
                    FileOutputStream out = new FileOutputStream(new File(Minecraft.func_71410_x().field_71412_D.getPath() + "/config/BetterFonts.cfg"));
                    while ((readBytes = stream.read(buffer)) > 0) {
                        ((OutputStream)out).write(buffer, 0, readBytes);
                    }
                }
                catch (IOException e) {
                    System.out.println("[BetterFonts]IOException on creating config");
                    System.out.println("BetterFonts failed to create new config file.");
                }
            }
            FileInputStream cfgFile = new FileInputStream(cfg);
            this.cfgProps.load(cfgFile);
            cfgFile.close();
            success = true;
        }
        catch (IOException e) {
            System.out.println("BetterFonts " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.out.println("BetterFonts " + e.getMessage());
        }
        return success;
    }

    public String getFontName(String defaultValue) {
        String fontName = this.cfgProps.getProperty("font.name");
        if (fontName == null) {
            return defaultValue;
        }
        String searchName = fontName.replaceAll("[- ]", "").toLowerCase();
        for (int i = 0; i < LOGICAL_FONTS.length; ++i) {
            if (LOGICAL_FONTS[i].compareToIgnoreCase(searchName) != 0) continue;
            return LOGICAL_FONTS[i];
        }
        String altSearchName = searchName + " medium";
        String partialMatch = null;
        for (int index = 0; index < this.allFonts.length; ++index) {
            Font font = this.allFonts[index];
            String name = font.getName().replaceAll("[- ]", "");
            if (name.compareToIgnoreCase(searchName) == 0 || name.compareToIgnoreCase(altSearchName) == 0) {
                return font.getName();
            }
            if ((name + font.getFamily()).replaceAll("[- ]", "").toLowerCase().indexOf(searchName) == -1 || partialMatch != null && partialMatch.length() <= font.getName().length()) continue;
            partialMatch = font.getName();
        }
        if (partialMatch != null) {
            return partialMatch;
        }
        System.out.println("BetterFonts cannot find font.name \"" + fontName + "\"");
        return defaultValue;
    }

    public int getFontSize(int defaultValue) {
        String value = this.cfgProps.getProperty("font.size");
        if (value == null) {
            return defaultValue;
        }
        try {
            int i = Integer.parseInt(value);
            if (i <= 0) {
                throw new NumberFormatException();
            }
            defaultValue = i;
        }
        catch (NumberFormatException e) {
            System.out.println("BetterFonts font.size must be an integer greater than zero");
        }
        return defaultValue;
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        String value = this.cfgProps.getProperty(propertyName);
        if (value == null) {
            return defaultValue;
        }
        if (value.compareToIgnoreCase("true") == 0) {
            return true;
        }
        if (value.compareToIgnoreCase("false") == 0) {
            return false;
        }
        System.out.println("BetterFonts " + propertyName + " must be either \"true\" or \"false\"");
        return defaultValue;
    }
}

