package mods.nandonalt.coralmod;

import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.Icon;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class ItemCoral extends ItemBlock {

	@SideOnly(Side.CLIENT)
	private Icon[] iconBuffer;

	private static final String[] types = BlockCoral.types;

	public ItemCoral(int itemID) {
		super(itemID);
		setMaxDamage(0);
		setHasSubtypes(true);
	}

	@Override
	public int getMetadata(int itemDamage) {
		return itemDamage;
	}

	// Forces item textures to be used
	@Override
	public int getSpriteNumber() {
		return 1;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerIcons(IconRegister iconRegister) {
		iconBuffer = new Icon[types.length];

		for (int i = 0; i < types.length; i++) {
			iconBuffer[i] = iconRegister.registerIcon("coralmod:" + types[i]);
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public Icon getIconFromDamage(int damageValue) {
		final Icon sprite;
		if(damageValue < 0 || damageValue > iconBuffer.length) {
			sprite = iconBuffer[0];
		} else {
			sprite = iconBuffer[damageValue];
		}

		return sprite;
	}

}
