/*
 * Decompiled with CFR 0.152.
 */
package panoramakitcore.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CodeTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if ("bfe".equals(name)) {
            ClassNode classNode = this.readBytes(bytes);
            this.doViewPositionTransform(classNode);
            bytes = this.writeBytes(classNode);
        }
        return bytes;
    }

    public ClassNode doViewPositionTransform(ClassNode classNode) {
        block0: for (MethodNode mn : classNode.methods) {
            if (!"g".equals(mn.name)) continue;
            for (AbstractInsnNode instruction : mn.instructions) {
                if (!(instruction instanceof LineNumberNode) || ((LineNumberNode)instruction).line != 551) continue;
                AbstractInsnNode nextLineNumInstr = instruction.getNext();
                while (!(nextLineNumInstr instanceof LineNumberNode)) {
                    nextLineNumInstr = nextLineNumInstr.getNext();
                }
                LabelNode jumpTo = ((LineNumberNode)nextLineNumInstr).start;
                InsnList customInstrList = new InsnList();
                customInstrList.add((AbstractInsnNode)new MethodInsnNode(184, "panoramakitcore/CoreStates", "isRendering", "()Z"));
                customInstrList.add((AbstractInsnNode)new JumpInsnNode(154, jumpTo));
                mn.instructions.insertBefore(instruction, customInstrList);
                break block0;
            }
        }
        return classNode;
    }

    private ClassNode readBytes(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassNode cn = new ClassNode(262144);
        cr.accept((ClassVisitor)cn, 8);
        return cn;
    }

    private byte[] writeBytes(ClassNode cn) {
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }
}

