/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.util;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import panoramakit.gui.settings.ModSettings;
import panoramakit.mod.PanoramaKit;

public class FileNumerator {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public static File numberFile(File file) {
        ModSettings settings = PanoramaKit.instance.getModSettings();
        if (ModSettings.fileNumberingOptions[settings.getFileNumbering()] == ModSettings.increment) {
            return FileNumerator.increment(file);
        }
        if (ModSettings.fileNumberingOptions[settings.getFileNumbering()] == ModSettings.date) {
            return FileNumerator.date(file);
        }
        return file;
    }

    public static File increment(File file) {
        file = FileNumerator.cleanFilePath(file);
        File parent = file.getParentFile();
        String name = file.getName().substring(0, file.getName().lastIndexOf(46));
        String extension = file.getName().substring(file.getName().lastIndexOf(46));
        int fileNumber = 2;
        while (file.exists()) {
            file = new File(parent, String.valueOf(name) + fileNumber + extension);
            ++fileNumber;
        }
        return file;
    }

    public static File date(File file) {
        file = FileNumerator.cleanFilePath(file);
        File parent = file.getParentFile();
        String fileName = file.getName();
        String name = fileName.substring(0, fileName.lastIndexOf(46));
        String extension = fileName.substring(fileName.lastIndexOf(46));
        return new File(parent, String.valueOf(DATE_FORMAT.format(new Date())) + " " + name + extension);
    }

    public static File cleanFilePath(File file) {
        String filePath = file.getPath();
        filePath = filePath.replaceAll("/./", "/");
        filePath = filePath.replaceAll("\\\\.\\\\", "\\\\");
        return new File(filePath);
    }
}

