/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.settings;

import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import panoramakit.mod.PanoramaKit;

public class StereographicSettings {
    private final PanoramaKit pk = PanoramaKit.instance;
    private final Configuration config = this.pk.getConfig();
    private static final int DEF_PANORAMA_WIDTH = 1920;
    private static final int DEF_PANORAMA_HEIGHT = 1080;
    private static final double DEF_SAMPLE_SIZE = 1.0;
    private static final double DEF_FIELD_OF_VIEW = 90.0;
    private static final double DEF_ANGLE = 90.0;
    private Property width;
    private Property height;
    private Property sampleSize;
    private Property fieldOfView;
    private Property angle;

    public StereographicSettings() {
        String category = "stereographic";
        this.width = this.config.get(category, "width", 1920);
        this.height = this.config.get(category, "height", 1080);
        this.sampleSize = this.config.get(category, "samplesize", 1.0);
        this.fieldOfView = this.config.get(category, "fieldofview", 90.0);
        this.angle = this.config.get(category, "angle", 90.0);
    }

    public int getWidth() {
        return this.width.getInt(1920);
    }

    public void setWidth(int width) {
        this.width.set(width);
    }

    public int getHeight() {
        return this.height.getInt(1080);
    }

    public void setHeight(int height) {
        this.height.set(height);
    }

    public float getSampleSize() {
        return (float)this.sampleSize.getDouble(1.0);
    }

    public void setSampleSize(float size) {
        this.sampleSize.set((double)size);
    }

    public float getFieldOfView() {
        return (float)this.fieldOfView.getDouble(90.0);
    }

    public void setFieldOfView(float fieldOfView) {
        this.fieldOfView.set((double)fieldOfView);
    }

    public float getAngle() {
        return (float)this.angle.getDouble(90.0);
    }

    public void setAngle(float angle) {
        this.angle.set((double)angle);
    }
}

