/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.settings;

import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import panoramakit.mod.PanoramaKit;

public class CylindricalSettings {
    private final PanoramaKit pk = PanoramaKit.instance;
    private final Configuration config = this.pk.getConfig();
    private static final int DEF_PANORAMA_WIDTH = 2000;
    private static final int DEF_PANORAMA_HEIGHT = 800;
    private static final double DEF_SAMPLE_SIZE = 1.0;
    private static final double DEF_ANGLE = 0.0;
    private Property width;
    private Property height;
    private Property sampleSize;
    private Property angle;

    public CylindricalSettings() {
        String category = "cylindrical";
        this.width = this.config.get(category, "width", 2000);
        this.height = this.config.get(category, "height", 800);
        this.sampleSize = this.config.get(category, "samplesize", 1.0);
        this.angle = this.config.get(category, "angle", 0.0);
    }

    public int getWidth() {
        return this.width.getInt(2000);
    }

    public void setWidth(int width) {
        this.width.set(width);
    }

    public int getHeight() {
        return this.height.getInt(800);
    }

    public void setHeight(int height) {
        this.height.set(height);
    }

    public float getSampleSize() {
        return (float)this.sampleSize.getDouble(1.0);
    }

    public void setSampleSize(float size) {
        this.sampleSize.set((double)size);
    }

    public float getAngle() {
        return (float)this.angle.getDouble(0.0);
    }

    public void setAngle(float angle) {
        this.angle.set((double)angle);
    }
}

