/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.gui.screens.settingsscreens;

import java.io.File;
import java.util.logging.Logger;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSmallButton;
import panoramakit.converter.ProjectionConverter;
import panoramakit.converter.projections.CubicToEquirect;
import panoramakit.converter.projections.EquirectToStereographic;
import panoramakit.engine.render.ImageLink;
import panoramakit.engine.render.renderers.CubicRenderer;
import panoramakit.engine.task.TaskManager;
import panoramakit.engine.task.tasks.DisplayGuiScreenTask;
import panoramakit.engine.task.tasks.RenderTask;
import panoramakit.engine.task.threadedtasks.ProjectionConverterTask;
import panoramakit.gui.PreviewRenderer;
import panoramakit.gui.menuitems.GuiCustomSlider;
import panoramakit.gui.menuitems.GuiCustomSliderOrientation;
import panoramakit.gui.menuitems.GuiCustomSliderSample;
import panoramakit.gui.menuitems.GuiCustomTextField;
import panoramakit.gui.screens.GuiRenderNotice;
import panoramakit.gui.screens.menuscreens.GuiMenuPanoramas;
import panoramakit.gui.screens.settingsscreens.GuiScreenSettings;
import panoramakit.gui.settings.SharedSettings;
import panoramakit.gui.settings.StereographicSettings;
import panoramakit.gui.util.FileNumerator;
import panoramakit.mod.PanoramaKit;

public class GuiSettingsStereographic
extends GuiScreenSettings {
    private static Logger L = PanoramaKit.instance.L;
    private static String screenTitle = "Stereographic \"Little planet\" Panorama";
    private static String screenLabel = "Stereographic \"Little planet\"";
    private static final int WIDTH = 0;
    private static final int HEIGHT = 1;
    private static final int SAMPLE_SIZE = 2;
    private static final int ORIENTATION = 3;
    private static final int ANGLE = 4;
    private static final int FIELD_OF_VIEW = 5;
    private static final int PREVIEW = 6;
    private static final int BACK = 7;
    private static final int CAPTURE = 8;
    private StereographicSettings settings = new StereographicSettings();

    public GuiSettingsStereographic() {
        super(screenLabel);
    }

    public void func_73866_w_() {
        this.field_73887_h.clear();
        this.textFieldList.clear();
        int leftCol = this.field_73880_f / 2 - 75 - 5;
        int rightCol = this.field_73880_f / 2 + 75 + 5;
        int contentStart = this.field_73881_g / 2 - 84;
        int bottomRow = this.field_73881_g / 2 + 84;
        int rowHeight = 24;
        int currentY = contentStart + 12;
        GuiCustomTextField fieldWidth = new GuiCustomTextField(this.field_73886_k, 0, leftCol - 12 - 64, currentY, 64, 20, true);
        GuiCustomTextField fieldHeight = new GuiCustomTextField(this.field_73886_k, 1, leftCol + 12, currentY, 64, 20, true);
        fieldWidth.func_73782_a(String.valueOf(this.settings.getWidth()));
        fieldHeight.func_73782_a(String.valueOf(this.settings.getHeight()));
        this.textFieldList.add(fieldWidth);
        this.textFieldList.add(fieldHeight);
        this.field_73887_h.add(new GuiCustomSliderSample(2, leftCol - 75, currentY += 24, this, "Sample Size", "Warning! Large samples eat lots of RAM!", 1.0f, 8.0f, 0.5f, this.settings.getSampleSize()));
        this.field_73887_h.add(new GuiCustomSliderOrientation(3, leftCol - 75, currentY += 24, this, "Orientation", "", -180.0f, 180.0f, 0.0f, SharedSettings.getOrientation()));
        this.field_73887_h.add(new GuiCustomSlider(4, leftCol - 75, currentY += 24, this, "Angle", "", -90.0f, 90.0f, 0.0f, this.settings.getAngle()){

            @Override
            public void updateDisplayString() {
                this.field_73744_e = String.format(String.valueOf(this.baseString) + ": %.1f", Float.valueOf(this.getValue()));
                if (this.getValue() == 90.0f) {
                    this.field_73744_e = "Planet";
                }
                if (this.getValue() == -90.0f) {
                    this.field_73744_e = "Inverted";
                }
            }
        });
        this.field_73887_h.add(new GuiCustomSlider(5, leftCol - 75, currentY += 24, this, "Field of View", "", 0.0f, 180.0f, 0.0f, this.settings.getFieldOfView()));
        this.field_73887_h.add(new GuiButton(6, rightCol - 40, contentStart + 128 + 6, 80, 20, "Preview"));
        this.field_73887_h.add(new GuiSmallButton(7, leftCol - 75, bottomRow, "Back"));
        this.field_73887_h.add(new GuiSmallButton(8, rightCol - 75, bottomRow, "Capture"));
    }

    @Override
    public void func_73863_a(int x, int y, float z) {
        int leftCol = this.field_73880_f / 2 - 75 - 5;
        int rightCol = this.field_73880_f / 2 + 75 + 5;
        int contentStart = this.field_73881_g / 2 - 84;
        int bottomRow = this.field_73881_g / 2 + 84;
        this.func_73873_v_();
        this.func_73732_a(this.field_73886_k, screenTitle, this.field_73880_f / 2, contentStart - 24, 0xFFFFFF);
        this.func_73732_a(this.field_73886_k, "Width", leftCol - 32 - 12, contentStart, 0xA0A0A0);
        this.func_73732_a(this.field_73886_k, "Height", leftCol + 32 + 12, contentStart, 0xA0A0A0);
        this.func_73731_b(this.field_73886_k, "x", leftCol - 2, contentStart + 16, 0xFFFFFF);
        GuiSettingsStereographic.func_73734_a((int)(rightCol - 64 - 1), (int)(contentStart - 1), (int)(rightCol - 64 + 128 + 1), (int)(contentStart + 128 + 1), (int)-16777216);
        GuiSettingsStereographic.func_73734_a((int)(rightCol - 64), (int)contentStart, (int)(rightCol - 64 + 128), (int)(contentStart + 128), (int)-14145496);
        if (this.previewRenderer.previewAvailable()) {
            this.previewRenderer.drawCenteredImage(rightCol - 64, contentStart, 128, 128);
        }
        int sampleResolution = (int)((float)((this.settings.getWidth() > this.settings.getHeight() ? this.settings.getWidth() : this.settings.getHeight()) / 4) * this.settings.getSampleSize());
        int sampleWidth = sampleResolution * 4;
        int sampleHeight = sampleResolution * 3;
        this.func_73732_a(this.field_73886_k, "Sampled image: " + sampleWidth + "x" + sampleHeight, leftCol, bottomRow - 24 - 4, 0xA0A0A0);
        this.func_73732_a(this.field_73886_k, this.tipMessage, this.field_73880_f / 2, bottomRow - 12, 0xFFCF33);
        super.func_73863_a(x, y, z);
    }

    @Override
    public void buttonPressed(GuiButton button, int id, int value) {
        if (id == 7) {
            field_73882_e.func_71373_a((GuiScreen)new GuiMenuPanoramas());
        }
        if (id == 8) {
            L.info("Render stereographic panorama");
            File renderFile = new File(PanoramaKit.instance.getRenderDir(), "Stereographic.png");
            renderFile = FileNumerator.numberFile(renderFile);
            EquirectToStereographic panorama = new EquirectToStereographic(new CubicToEquirect(), this.settings.getFieldOfView(), this.settings.getWidth(), this.settings.getHeight());
            ProjectionConverter converter = new ProjectionConverter(panorama, renderFile);
            int sampleResolution = (int)((float)((this.settings.getWidth() > this.settings.getHeight() ? this.settings.getWidth() : this.settings.getHeight()) / 4) * this.settings.getSampleSize());
            CubicRenderer renderer = new CubicRenderer(sampleResolution, renderFile, SharedSettings.getOrientation() - 180.0f, this.settings.getAngle() - 90.0f);
            TaskManager.instance.addTask(new RenderTask(renderer));
            TaskManager.instance.addTask(new ProjectionConverterTask(converter));
            ImageLink imageLink = new ImageLink();
            renderer.setImageLink(imageLink);
            converter.setImageLink(imageLink);
            field_73882_e.func_71373_a((GuiScreen)new GuiRenderNotice());
        }
        if (id == 6) {
            L.info("Render preview panorama");
            File previewFile = PreviewRenderer.getPreviewFile();
            int previewSize = 256;
            double fullWidth = this.settings.getWidth();
            double fullHeight = this.settings.getHeight();
            int panoramaWidth = fullWidth > fullHeight ? previewSize : (int)((double)previewSize * fullWidth / fullHeight);
            int panoramaHeight = fullHeight > fullWidth ? previewSize : (int)((double)previewSize * fullHeight / fullWidth);
            EquirectToStereographic panorama = new EquirectToStereographic(new CubicToEquirect(), this.settings.getFieldOfView(), panoramaWidth, panoramaHeight);
            ProjectionConverter converter = new ProjectionConverter(panorama, previewFile);
            int sampleResolution = 256;
            CubicRenderer renderer = new CubicRenderer(sampleResolution, previewFile, SharedSettings.getOrientation() - 180.0f, this.settings.getAngle() - 90.0f);
            TaskManager.instance.addTask(new RenderTask(renderer));
            TaskManager.instance.addTask(new DisplayGuiScreenTask(((Object)((Object)this)).getClass()));
            ProjectionConverterTask projectionTask = new ProjectionConverterTask(converter);
            projectionTask.setSilent();
            TaskManager.instance.addTask(projectionTask);
            ImageLink imageLink = new ImageLink();
            renderer.setImageLink(imageLink);
            converter.setImageLink(imageLink);
            this.capturePreview();
        }
    }

    @Override
    public void sliderMoved(int id, float value) {
        if (id == 2) {
            this.settings.setSampleSize(value);
        }
        if (id == 3) {
            SharedSettings.setOrientation(value);
        }
        if (id == 4) {
            this.settings.setAngle(value);
        }
        if (id == 5) {
            this.settings.setFieldOfView(value);
        }
    }

    @Override
    public void textFieldUpdated(GuiCustomTextField textField, int id, String value) {
        int intValue = -1;
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id == 0) {
            if (intValue >= 4) {
                this.settings.setWidth(intValue);
            } else {
                textField.setError(true);
            }
        }
        if (id == 1) {
            if (intValue >= 4) {
                this.settings.setHeight(intValue);
            } else {
                textField.setError(true);
            }
        }
    }
}

