/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zipper {
    public static void zipFolder(File folder, File zipFile) throws IOException, Exception {
        if (!folder.exists()) {
            throw new FileNotFoundException("Folder doesn't exist: " + folder.getName());
        }
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("That's not a folder!");
        }
        if (zipFile.exists() && !zipFile.delete()) {
            throw new Exception("Zip Failed: Existing file can't be deleted.");
        }
        if (!zipFile.getParentFile().exists()) {
            zipFile.mkdirs();
        }
        zipFile.createNewFile();
        FileOutputStream fileOut = new FileOutputStream(zipFile);
        ZipOutputStream zipOut = new ZipOutputStream(fileOut);
        Zipper.addFolder("", folder, zipOut);
        zipOut.flush();
        zipOut.close();
    }

    private static void addFolder(String currentPath, File folder, ZipOutputStream zipOut) throws IOException {
        currentPath = String.valueOf(currentPath) + folder.getName() + "/";
        File[] fileArray = folder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File item = fileArray[n2];
            if (item.isDirectory()) {
                Zipper.addFolder(currentPath, item, zipOut);
            } else {
                Zipper.addFileEntry(currentPath, item, zipOut);
            }
            ++n2;
        }
    }

    private static void addFileEntry(String currentPath, File file, ZipOutputStream zipOut) throws IOException {
        int length;
        byte[] buffer = new byte[0x400000];
        FileInputStream in = new FileInputStream(file);
        ZipEntry entry = new ZipEntry(String.valueOf(currentPath) + file.getName());
        zipOut.putNextEntry(entry);
        while ((length = in.read(buffer)) > 0) {
            zipOut.write(buffer, 0, length);
        }
        in.close();
        zipOut.closeEntry();
    }
}

