/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.task;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import panoramakit.engine.task.Task;
import panoramakit.engine.task.ThreadedTask;

public class TaskManager {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public static final TaskManager instance = new TaskManager();
    private Task activeTask = null;
    private ArrayList<Task> taskQueue = new ArrayList();

    public void addTask(Task task) {
        this.taskQueue.add(task);
    }

    public boolean hasTasks() {
        return !this.taskQueue.isEmpty() || this.activeTask != null;
    }

    public int tasksInQueue() {
        return this.taskQueue.size();
    }

    public Task getCurrentTask() {
        return this.activeTask;
    }

    public void halt() {
        if (this.hasTasks()) {
            this.taskQueue.clear();
            this.activeTask.stop();
        }
    }

    public void runTick() {
        if (!this.hasTasks()) {
            return;
        }
        if (TaskManager.mc.field_71462_r instanceof GuiMemoryErrorScreen) {
            this.halt();
        }
        do {
            if (this.activeTask == null) {
                this.runNextTask();
            }
            this.activeTask.perform();
            this.clearTaskIfCompleted();
            this.clearTaskIfStopped();
        } while (this.activeTask == null && this.taskQueue.size() > 0);
    }

    private void runNextTask() {
        if (this.taskQueue.size() > 0) {
            this.activeTask = this.taskQueue.get(0);
            this.taskQueue.remove(0);
            this.activeTask.init();
            if (this.activeTask instanceof ThreadedTask) {
                ((ThreadedTask)this.activeTask).start();
            }
        }
    }

    private void clearTaskIfCompleted() {
        if (this.activeTask != null && this.activeTask.hasCompleted()) {
            this.activeTask.finish();
            this.activeTask = null;
        }
    }

    private void clearTaskIfStopped() {
        if (this.activeTask != null && this.activeTask.hasStopped()) {
            this.activeTask = null;
        }
    }
}

