/*
 * Decompiled with CFR 0.152.
 */
package panoramakit.engine.render.renderers;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.util.MathHelper;
import panoramakit.engine.render.CompositeImageRenderer;
import panoramakit.mod.PanoramaKit;

public class CubicRenderer
extends CompositeImageRenderer {
    private final Logger L;
    private int resolution;
    private File file;
    private float orientation;
    private float angle;

    public CubicRenderer(int resolution, File file, float orientation, float angle) {
        super(resolution, resolution);
        this.L = PanoramaKit.instance.L;
        this.resolution = resolution;
        this.file = file;
        this.orientation = orientation;
        this.angle = angle;
    }

    @Override
    public void assembleImage() throws IOException {
        int[] screenshot;
        float roll;
        float pitch;
        float yaw;
        long startTime = System.currentTimeMillis();
        BufferedImage image = new BufferedImage(4 * this.resolution, 3 * this.resolution, 2);
        float radianMultiplier = (float)Math.PI / 180;
        int i = 0;
        while (i < 4) {
            yaw = (i - 1) * 90;
            pitch = -this.angle * MathHelper.func_76134_b((float)(yaw * radianMultiplier));
            roll = this.angle * MathHelper.func_76126_a((float)(yaw * radianMultiplier));
            yaw += this.orientation;
            if (pitch > 90.0f) {
                pitch = 180.0f - pitch;
                yaw += 180.0f;
                roll += 180.0f;
            }
            if (pitch < -90.0f) {
                pitch = -180.0f - pitch;
                yaw += 180.0f;
                roll += 180.0f;
            }
            this.rotatePlayer(yaw, pitch, roll);
            screenshot = this.captureScreenshot();
            image.setRGB(i * this.resolution, this.resolution, this.resolution, this.resolution, screenshot, 0, this.resolution);
            ++i;
        }
        i = 0;
        while (i <= 2) {
            yaw = this.orientation;
            pitch = (float)((i - 1) * 90) - this.angle;
            roll = 0.0f;
            if ((pitch = (pitch + 180.0f) % 360.0f - 180.0f) > 90.0f) {
                pitch = 180.0f - pitch;
                yaw += 180.0f;
                roll += 180.0f;
            }
            if (pitch < -90.0f) {
                pitch = -180.0f - pitch;
                yaw += 180.0f;
                roll += 180.0f;
            }
            this.rotatePlayer(yaw, pitch, roll);
            screenshot = this.captureScreenshot();
            image.setRGB(this.resolution, i * this.resolution, this.resolution, this.resolution, screenshot, 0, this.resolution);
            i += 2;
        }
        if (this.imageLink == null) {
            if (!this.file.exists()) {
                this.file.mkdirs();
                this.file.createNewFile();
            }
            ImageIO.write((RenderedImage)image, "png", this.file);
            this.chat.print("panoramakit.saveimage", this.file.getName());
        } else {
            this.imageLink.setImage(image);
        }
        this.L.info("Cubic render: " + (System.currentTimeMillis() - startTime) + "ms");
    }
}

